/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MarkDistinctNode
extends PlanNode {
    private final PlanNode source;
    private final Symbol markerSymbol;
    private final List<Symbol> distinctSymbols;
    private final Optional<Symbol> sampleWeightSymbol;

    @JsonCreator
    public MarkDistinctNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="markerSymbol") Symbol markerSymbol, @JsonProperty(value="distinctSymbols") List<Symbol> distinctSymbols, @JsonProperty(value="sampleWeightSymbol") Optional<Symbol> sampleWeightSymbol) {
        super(id);
        this.source = source;
        this.markerSymbol = markerSymbol;
        this.distinctSymbols = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(distinctSymbols, (Object)"distinctSymbols is null")));
        this.sampleWeightSymbol = (Optional)Preconditions.checkNotNull(sampleWeightSymbol, (Object)"sampleWeightSymbol is null");
        if (sampleWeightSymbol.isPresent()) {
            Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(sampleWeightSymbol.get()), (Object)"source does not output sample weight");
        }
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.markerSymbol).build();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public Optional<Symbol> getSampleWeightSymbol() {
        return this.sampleWeightSymbol;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Symbol getMarkerSymbol() {
        return this.markerSymbol;
    }

    @JsonProperty
    public List<Symbol> getDistinctSymbols() {
        return this.distinctSymbols;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitMarkDistinct(this, context);
    }
}

