/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LimitNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final Optional<Symbol> sampleWeight;

    @JsonCreator
    public LimitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="sampleWeight") Optional<Symbol> sampleWeight) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must be greater than or equal to zero");
        Preconditions.checkNotNull(sampleWeight, (Object)"sampleWeight is null");
        if (sampleWeight.isPresent()) {
            Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(sampleWeight.get()), (Object)"source does not output sample weight");
        }
        this.source = source;
        this.count = count;
        this.sampleWeight = sampleWeight;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="count")
    public long getCount() {
        return this.count;
    }

    @JsonProperty(value="sampleWeight")
    public Optional<Symbol> getSampleWeight() {
        return this.sampleWeight;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitLimit(this, context);
    }
}

