/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExchangeNode
extends PlanNode {
    private final List<PlanFragmentId> sourceFragmentIds;
    private final List<Symbol> outputs;

    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sourceFragmentIds") List<PlanFragmentId> sourceFragmentIds, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        Preconditions.checkNotNull(outputs, (Object)"outputs is null");
        this.sourceFragmentIds = sourceFragmentIds;
        this.outputs = ImmutableList.copyOf(outputs);
    }

    public ExchangeNode(PlanNodeId id, PlanFragmentId sourceFragmentId, List<Symbol> outputs) {
        this(id, (List<PlanFragmentId>)ImmutableList.of((Object)sourceFragmentId), outputs);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty(value="sourceFragmentIds")
    public List<PlanFragmentId> getSourceFragmentIds() {
        return this.sourceFragmentIds;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    public static Function<ExchangeNode, List<PlanFragmentId>> sourceFragmentIdsGetter() {
        return new Function<ExchangeNode, List<PlanFragmentId>>(){

            public List<PlanFragmentId> apply(ExchangeNode input) {
                return input.getSourceFragmentIds();
            }
        };
    }
}

