/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LimitPushDown
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, ConnectorSession session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(idAllocator), plan, null);
    }

    private static class Rewriter
    extends PlanNodeRewriter<LimitContext> {
        private final PlanNodeIdAllocator idAllocator;

        private Rewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        }

        @Override
        public PlanNode rewriteNode(PlanNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            PlanNode rewrittenNode = planRewriter.defaultRewrite(node, null);
            if (context != null) {
                rewrittenNode = new LimitNode(this.idAllocator.getNextId(), rewrittenNode, context.getCount(), context.getSampleWeight());
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode rewriteLimit(LimitNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            if (context != null && context.getCount() < node.getCount()) {
                if (context.getSampleWeight().isPresent()) {
                    Preconditions.checkState((node.getSampleWeight().isPresent() && node.getSampleWeight().equals(context.getSampleWeight()) ? 1 : 0) != 0, (Object)"sample weight symbols don't match");
                }
                return planRewriter.rewrite(node.getSource(), context);
            }
            return planRewriter.rewrite(node.getSource(), new LimitContext(node.getCount(), node.getSampleWeight()));
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            if (context != null && node.getAggregations().isEmpty() && node.getOutputSymbols().size() == node.getGroupBy().size() && node.getOutputSymbols().containsAll(node.getGroupBy())) {
                Preconditions.checkArgument((!context.getSampleWeight().isPresent() ? 1 : 0) != 0, (Object)"sample weight symbol referenced after a DISTINCT node");
                Preconditions.checkArgument((!node.getSampleWeight().isPresent() ? 1 : 0) != 0, (Object)"DISTINCT aggregation has sample weight symbol");
                PlanNode rewrittenSource = planRewriter.rewrite(node.getSource(), null);
                return new DistinctLimitNode(this.idAllocator.getNextId(), rewrittenSource, context.getCount());
            }
            PlanNode rewrittenNode = planRewriter.defaultRewrite(node, null);
            if (context != null) {
                Preconditions.checkState((!context.getSampleWeight().isPresent() ? 1 : 0) != 0, (Object)"Aggregations do not output a sample weight, but limit consumes one");
                rewrittenNode = new LimitNode(this.idAllocator.getNextId(), rewrittenNode, context.getCount(), (Optional<Symbol>)Optional.absent());
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode rewriteMarkDistinct(MarkDistinctNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            return planRewriter.defaultRewrite(node, context);
        }

        @Override
        public PlanNode rewriteProject(ProjectNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            Symbol sampleWeightSymbol;
            Symbol symbol = sampleWeightSymbol = context != null ? (Symbol)context.getSampleWeight().orNull() : null;
            if (sampleWeightSymbol == null) {
                return planRewriter.defaultRewrite(node, context);
            }
            Expression expression = node.getOutputMap().get(sampleWeightSymbol);
            if (expression instanceof QualifiedNameReference) {
                Symbol unaliasedSampleWeightSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
                context = new LimitContext(context.getCount(), (Optional<Symbol>)Optional.of((Object)unaliasedSampleWeightSymbol));
                PlanNode source = planRewriter.rewrite(node.getSource(), context);
                return new ProjectNode(node.getId(), source, node.getOutputMap());
            }
            PlanNode rewrittenNode = planRewriter.defaultRewrite(node, null);
            rewrittenNode = new LimitNode(this.idAllocator.getNextId(), rewrittenNode, context.getCount(), context.getSampleWeight());
            return rewrittenNode;
        }

        @Override
        public PlanNode rewriteTopN(TopNNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            PlanNode rewrittenSource = planRewriter.rewrite(node.getSource(), null);
            if (rewrittenSource == node.getSource() && context == null) {
                return node;
            }
            long count = node.getCount();
            Optional<Symbol> sampleWeight = node.getSampleWeight();
            if (context != null) {
                count = Math.min(count, context.getCount());
                if (context.getSampleWeight().isPresent()) {
                    Preconditions.checkState((sampleWeight.isPresent() && sampleWeight.equals(context.getSampleWeight()) ? 1 : 0) != 0, (Object)"limit and topN sample weight symbols don't match");
                }
            }
            return new TopNNode(node.getId(), rewrittenSource, count, node.getOrderBy(), node.getOrderings(), node.isPartial(), sampleWeight);
        }

        @Override
        public PlanNode rewriteSort(SortNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            PlanNode rewrittenSource = planRewriter.rewrite(node.getSource(), null);
            if (context != null) {
                return new TopNNode(node.getId(), rewrittenSource, context.getCount(), node.getOrderBy(), node.getOrderings(), false, context.getSampleWeight());
            }
            if (rewrittenSource != node.getSource()) {
                return new SortNode(node.getId(), rewrittenSource, node.getOrderBy(), node.getOrderings());
            }
            return node;
        }

        @Override
        public PlanNode rewriteUnion(UnionNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            List sampleWeights = null;
            if (context != null && context.getSampleWeight().isPresent()) {
                sampleWeights = node.getSymbolMapping().get(context.getSampleWeight().get());
            }
            ArrayList<PlanNode> sources = new ArrayList<PlanNode>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                LimitContext rewrittenContext = context;
                if (sampleWeights != null) {
                    rewrittenContext = new LimitContext(context.getCount(), (Optional<Symbol>)Optional.of(sampleWeights.get(i)));
                }
                sources.add(planRewriter.rewrite(node.getSources().get(i), rewrittenContext));
            }
            PlanNode output = new UnionNode(node.getId(), sources, node.getSymbolMapping());
            if (context != null) {
                output = new LimitNode(this.idAllocator.getNextId(), output, context.getCount(), context.getSampleWeight());
            }
            return output;
        }

        @Override
        public PlanNode rewriteSemiJoin(SemiJoinNode node, LimitContext context, PlanRewriter<LimitContext> planRewriter) {
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            if (source != node.getSource()) {
                return new SemiJoinNode(node.getId(), source, node.getFilteringSource(), node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput());
            }
            return node;
        }
    }

    private static class LimitContext {
        private final long count;
        private final Optional<Symbol> sampleWeight;

        public LimitContext(long count, Optional<Symbol> sampleWeight) {
            this.count = count;
            this.sampleWeight = (Optional)Preconditions.checkNotNull(sampleWeight, (Object)"sampleWeight is null");
        }

        public long getCount() {
            return this.count;
        }

        public Optional<Symbol> getSampleWeight() {
            return this.sampleWeight;
        }
    }
}

