/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class RelationPlan {
    private final PlanNode root;
    private final List<Symbol> outputSymbols;
    private final TupleDescriptor descriptor;

    public RelationPlan(PlanNode root, TupleDescriptor descriptor, List<Symbol> outputSymbols) {
        Preconditions.checkNotNull((Object)root, (Object)"root is null");
        Preconditions.checkNotNull(outputSymbols, (Object)"outputSymbols is null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor is null");
        Preconditions.checkArgument((descriptor.getAllFieldCount() == outputSymbols.size() ? 1 : 0) != 0, (String)"Number of outputs (%s) doesn't match descriptor size (%s)", (Object[])new Object[]{outputSymbols.size(), descriptor.getAllFieldCount()});
        this.root = root;
        this.descriptor = descriptor;
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
    }

    public Symbol getSymbol(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex >= 0 && fieldIndex < this.outputSymbols.size() && this.outputSymbols.get(fieldIndex) != null ? 1 : 0) != 0, (String)"No field->symbol mapping for field %s", (Object[])new Object[]{fieldIndex});
        return this.outputSymbols.get(fieldIndex);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    public TupleDescriptor getDescriptor() {
        return this.descriptor;
    }
}

