/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Approximate;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class QueryPlanner
extends DefaultTraversalVisitor<PlanBuilder, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final ConnectorSession session;

    QueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, ConnectorSession session) {
        Preconditions.checkNotNull((Object)analysis, (Object)"analysis is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
    }

    protected PlanBuilder visitQuery(Query query, Void context) {
        PlanBuilder builder = this.planQueryBody(query);
        Set<InPredicate> inPredicates = this.analysis.getInPredicates(query);
        builder = this.appendSemiJoins(builder, inPredicates);
        List<FieldOrExpression> orderBy = this.analysis.getOrderByExpressions((Node)query);
        List<FieldOrExpression> outputs = this.analysis.getOutputExpressions((Node)query);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.sort(builder, query);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)query));
        builder = this.limit(builder, query);
        return builder;
    }

    protected PlanBuilder visitQuerySpecification(QuerySpecification node, Void context) {
        PlanBuilder builder = this.planFrom(node);
        Set<InPredicate> inPredicates = this.analysis.getInPredicates(node);
        builder = this.appendSemiJoins(builder, inPredicates);
        builder = this.filter(builder, this.analysis.getWhere(node));
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node));
        builder = this.window(builder, node);
        List<FieldOrExpression> orderBy = this.analysis.getOrderByExpressions((Node)node);
        List<FieldOrExpression> outputs = this.analysis.getOutputExpressions((Node)node);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.distinct(builder, node, outputs, orderBy);
        builder = this.sort(builder, node);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)node));
        builder = this.limit(builder, node);
        return builder;
    }

    private PlanBuilder planQueryBody(Query query) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)query.getQueryBody(), null);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        RelationPlan relationPlan = node.getFrom() == null || node.getFrom().isEmpty() ? this.planImplicitTable() : (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)Iterables.getOnlyElement((Iterable)node.getFrom()), null);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private RelationPlan planImplicitTable() {
        ImmutableList emptyRow = ImmutableList.of();
        return new RelationPlan(new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)emptyRow)), new TupleDescriptor(new Field[0]), (List<Symbol>)ImmutableList.of());
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate) {
        if (predicate == null) {
            return subPlan;
        }
        Expression rewritten = subPlan.rewrite(predicate);
        return new PlanBuilder(subPlan.getTranslations(), new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), rewritten));
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<FieldOrExpression> expressions) {
        TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (FieldOrExpression fieldOrExpression : ImmutableSet.copyOf(expressions)) {
            Symbol symbol;
            if (fieldOrExpression.isFieldReference()) {
                Field field = subPlan.getRelationPlan().getDescriptor().getFieldByIndex(fieldOrExpression.getFieldIndex());
                symbol = this.symbolAllocator.newSymbol(field);
            } else {
                Expression expression = fieldOrExpression.getExpression();
                symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            }
            projections.put((Object)symbol, (Object)subPlan.rewrite(fieldOrExpression));
            outputTranslations.put(fieldOrExpression, symbol);
        }
        return new PlanBuilder(outputTranslations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()));
    }

    private Map<Symbol, Expression> coerce(Iterable<? extends Expression> expressions, PlanBuilder subPlan, TranslationMap translations) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Type coercion = this.analysis.getCoercion(expression);
            Symbol symbol = this.symbolAllocator.newSymbol(expression, (Type)Objects.firstNonNull((Object)coercion, (Object)this.analysis.getType(expression)));
            Expression rewritten = subPlan.rewrite(expression);
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getName());
            }
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(expression, symbol);
        }
        return projections.build();
    }

    private PlanBuilder explicitCoercionFields(PlanBuilder subPlan, Iterable<FieldOrExpression> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableMap.Builder projections = ImmutableMap.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (FieldOrExpression fieldOrExpression : alreadyCoerced) {
            Symbol symbol;
            if (fieldOrExpression.isFieldReference()) {
                Field field = subPlan.getRelationPlan().getDescriptor().getFieldByIndex(fieldOrExpression.getFieldIndex());
                symbol = this.symbolAllocator.newSymbol(field);
            } else {
                symbol = this.symbolAllocator.newSymbol(fieldOrExpression.getExpression(), this.analysis.getType(fieldOrExpression.getExpression()));
            }
            Expression rewritten = subPlan.rewrite(fieldOrExpression);
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(fieldOrExpression, symbol);
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()));
    }

    private PlanBuilder explicitCoercionSymbols(PlanBuilder subPlan, Iterable<Symbol> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableMap.Builder projections = ImmutableMap.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (Symbol symbol : alreadyCoerced) {
            projections.put((Object)symbol, (Object)new QualifiedNameReference(symbol.toQualifiedName()));
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()));
    }

    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        if (this.analysis.getAggregates(node).isEmpty() && this.analysis.getGroupByExpressions(node).isEmpty()) {
            return subPlan;
        }
        Set<FieldOrExpression> arguments = IterableTransformer.on(this.analysis.getAggregates(node)).transformAndFlatten(FunctionCall.argumentsGetter()).transform(QueryPlanner.toFieldOrExpression()).set();
        Iterable inputs = Iterables.concat(this.analysis.getGroupByExpressions(node), arguments);
        if (!Iterables.isEmpty((Iterable)inputs)) {
            subPlan = this.project(subPlan, inputs);
        }
        ImmutableMap.Builder aggregationAssignments = ImmutableMap.builder();
        ImmutableMap.Builder functions = ImmutableMap.builder();
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        boolean needPostProjectionCoercion = false;
        for (FunctionCall aggregate : this.analysis.getAggregates(node)) {
            Expression rewritten = subPlan.rewrite((Expression)aggregate);
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getType((Expression)aggregate));
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
                needPostProjectionCoercion = true;
            }
            aggregationAssignments.put((Object)newSymbol, (Object)((FunctionCall)rewritten));
            translations.put((Expression)aggregate, newSymbol);
            functions.put((Object)newSymbol, (Object)this.analysis.getFunctionInfo(aggregate).getSignature());
        }
        LinkedHashSet<Symbol> groupBySymbols = new LinkedHashSet<Symbol>();
        for (FieldOrExpression fieldOrExpression : this.analysis.getGroupByExpressions(node)) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            groupBySymbols.add(symbol);
            translations.put(fieldOrExpression, symbol);
        }
        HashMap<ImmutableSet, Symbol> argumentMarkers = new HashMap<ImmutableSet, Symbol>();
        HashMap<Symbol, Symbol> masks = new HashMap<Symbol, Symbol>();
        for (FunctionCall functionCall : Iterables.filter(this.analysis.getAggregates(node), (Predicate)FunctionCall.distinctPredicate())) {
            ImmutableSet args = ImmutableSet.copyOf((Collection)functionCall.getArguments());
            Symbol marker = (Symbol)argumentMarkers.get(args);
            Symbol aggregateSymbol = translations.get((Expression)functionCall);
            if (marker == null) {
                marker = args.size() == 1 ? this.symbolAllocator.newSymbol((Expression)Iterables.getOnlyElement((Iterable)args), (Type)BooleanType.BOOLEAN, "distinct") : this.symbolAllocator.newSymbol(aggregateSymbol.getName(), (Type)BooleanType.BOOLEAN, "distinct");
                argumentMarkers.put(args, marker);
            }
            masks.put(aggregateSymbol, marker);
        }
        for (Map.Entry entry : argumentMarkers.entrySet()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(groupBySymbols);
            for (Expression expression : (Set)entry.getKey()) {
                builder.add((Object)subPlan.translate(expression));
            }
            MarkDistinctNode markDistinct = new MarkDistinctNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Symbol)entry.getValue(), (List<Symbol>)builder.build(), (Optional<Symbol>)Optional.absent());
            subPlan = new PlanBuilder(subPlan.getTranslations(), markDistinct);
        }
        double confidence = 1.0;
        if (this.analysis.getQuery().getApproximate().isPresent()) {
            confidence = Double.valueOf(((Approximate)this.analysis.getQuery().getApproximate().get()).getConfidence()) / 100.0;
        }
        subPlan = new PlanBuilder(translations, new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)ImmutableList.copyOf(groupBySymbols), (Map<Symbol, FunctionCall>)aggregationAssignments.build(), (Map<Symbol, Signature>)functions.build(), (Map<Symbol, Symbol>)new ImmutableMap.Builder().putAll(masks).build(), (Optional<Symbol>)Optional.absent(), confidence));
        if (needPostProjectionCoercion) {
            return this.explicitCoercionFields(subPlan, this.analysis.getGroupByExpressions(node), this.analysis.getAggregates(node));
        }
        return subPlan;
    }

    private PlanBuilder window(PlanBuilder subPlan, QuerySpecification node) {
        ImmutableSet windowFunctions = ImmutableSet.copyOf(this.analysis.getWindowFunctions(node));
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        for (FunctionCall windowFunction : windowFunctions) {
            ImmutableList inputs = ImmutableList.builder().addAll((Iterable)windowFunction.getArguments()).addAll((Iterable)((Window)windowFunction.getWindow().get()).getPartitionBy()).addAll(Iterables.transform((Iterable)((Window)windowFunction.getWindow().get()).getOrderBy(), (Function)SortItem.sortKeyGetter())).build();
            subPlan = this.appendProjections(subPlan, (Iterable<Expression>)inputs);
            ImmutableList.Builder partitionBySymbols = ImmutableList.builder();
            for (Expression expression : ((Window)windowFunction.getWindow().get()).getPartitionBy()) {
                partitionBySymbols.add((Object)subPlan.translate(expression));
            }
            ImmutableList.Builder orderBySymbols = ImmutableList.builder();
            HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
            for (SortItem item : ((Window)windowFunction.getWindow().get()).getOrderBy()) {
                Symbol symbol = subPlan.translate(item.getSortKey());
                orderBySymbols.add((Object)symbol);
                orderings.put(symbol, this.toSortOrder(item));
            }
            TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
            outputTranslations.copyMappingsFrom(subPlan.getTranslations());
            ImmutableMap.Builder assignments = ImmutableMap.builder();
            HashMap<Symbol, Signature> signatures = new HashMap<Symbol, Signature>();
            Expression rewritten = subPlan.rewrite((Expression)windowFunction);
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getType((Expression)windowFunction));
            boolean needCoercion = rewritten instanceof Cast;
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
            }
            assignments.put((Object)newSymbol, (Object)((FunctionCall)rewritten));
            outputTranslations.put((Expression)windowFunction, newSymbol);
            signatures.put(newSymbol, this.analysis.getFunctionInfo(windowFunction).getSignature());
            List<Symbol> sourceSymbols = subPlan.getRoot().getOutputSymbols();
            subPlan = new PlanBuilder(outputTranslations, new WindowNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)partitionBySymbols.build(), (List<Symbol>)orderBySymbols.build(), orderings, (Map<Symbol, FunctionCall>)assignments.build(), signatures));
            if (!needCoercion) continue;
            subPlan = this.explicitCoercionSymbols(subPlan, sourceSymbols, (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
        }
        return subPlan;
    }

    private PlanBuilder appendProjections(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getRoot().getOutputSymbols()) {
            QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)qualifiedNameReference);
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            projections.put((Object)symbol, (Object)translations.rewrite(expression));
            newTranslations.put((Object)symbol, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()));
    }

    private PlanBuilder appendSemiJoins(PlanBuilder subPlan, Set<InPredicate> inPredicates) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendSemiJoin(subPlan, inPredicate);
        }
        return subPlan;
    }

    private PlanBuilder appendSemiJoin(PlanBuilder subPlan, InPredicate inPredicate) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        subPlan = this.appendProjections(subPlan, (Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()));
        Symbol sourceJoinSymbol = subPlan.translate(inPredicate.getValue());
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression subqueryExpression = (SubqueryExpression)inPredicate.getValueList();
        RelationPlanner relationPlanner = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        RelationPlan valueListRelation = (RelationPlan)relationPlanner.process((Node)subqueryExpression.getQuery(), null);
        Symbol filteringSourceJoinSymbol = (Symbol)Iterables.getOnlyElement(valueListRelation.getRoot().getOutputSymbols());
        Symbol semiJoinOutputSymbol = this.symbolAllocator.newSymbol("semijoinresult", (Type)BooleanType.BOOLEAN);
        translations.put((Expression)inPredicate, semiJoinOutputSymbol);
        return new PlanBuilder(translations, new SemiJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), valueListRelation.getRoot(), sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutputSymbol));
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node, List<FieldOrExpression> outputs, List<FieldOrExpression> orderBy) {
        if (node.getSelect().isDistinct()) {
            Preconditions.checkState((boolean)outputs.containsAll(orderBy), (Object)"Expected ORDER BY terms to be in SELECT. Broken analysis");
            AggregationNode aggregation = new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), subPlan.getRoot().getOutputSymbols(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), (Optional<Symbol>)Optional.absent(), 1.0);
            return new PlanBuilder(subPlan.getTranslations(), aggregation);
        }
        return subPlan;
    }

    private PlanBuilder sort(PlanBuilder subPlan, Query node) {
        return this.sort(subPlan, node.getOrderBy(), (Optional<String>)node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, QuerySpecification node) {
        return this.sort(subPlan, node.getOrderBy(), (Optional<String>)node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit, List<FieldOrExpression> orderByExpressions) {
        if (orderBy.isEmpty()) {
            return subPlan;
        }
        Iterator<SortItem> sortItems = orderBy.iterator();
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        ImmutableMap.Builder orderings = ImmutableMap.builder();
        for (FieldOrExpression fieldOrExpression : orderByExpressions) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            orderBySymbols.add((Object)symbol);
            orderings.put((Object)symbol, (Object)this.toSortOrder(sortItems.next()));
        }
        PlanNode planNode = limit.isPresent() ? new TopNNode(this.idAllocator.getNextId(), subPlan.getRoot(), Long.valueOf((String)limit.get()), (List<Symbol>)orderBySymbols.build(), (Map<Symbol, SortOrder>)orderings.build(), false, (Optional<Symbol>)Optional.absent()) : new SortNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)orderBySymbols.build(), (Map<Symbol, SortOrder>)orderings.build());
        return new PlanBuilder(subPlan.getTranslations(), planNode);
    }

    private PlanBuilder limit(PlanBuilder subPlan, Query node) {
        return this.limit(subPlan, node.getOrderBy(), (Optional<String>)node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, QuerySpecification node) {
        return this.limit(subPlan, node.getOrderBy(), (Optional<String>)node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit) {
        if (orderBy.isEmpty() && limit.isPresent()) {
            long limitValue = Long.valueOf((String)limit.get());
            return new PlanBuilder(subPlan.getTranslations(), new LimitNode(this.idAllocator.getNextId(), subPlan.getRoot(), limitValue, (Optional<Symbol>)Optional.absent()));
        }
        return subPlan;
    }

    private SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }

    public static Function<Expression, FieldOrExpression> toFieldOrExpression() {
        return new Function<Expression, FieldOrExpression>(){

            @Nullable
            public FieldOrExpression apply(Expression input) {
                return new FieldOrExpression(input);
            }
        };
    }
}

