/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.Map;

public class LookupSymbolResolver
implements SymbolResolver {
    private final Map<Symbol, Object> bindings;

    public LookupSymbolResolver(Map<Symbol, Object> bindings) {
        Preconditions.checkNotNull(bindings, (Object)"bindings is null");
        this.bindings = ImmutableMap.copyOf(bindings);
    }

    @Override
    public Object getValue(Symbol symbol) {
        if (!this.bindings.containsKey(symbol)) {
            return new QualifiedNameReference(symbol.toQualifiedName());
        }
        Object value = this.bindings.get(symbol);
        if (value instanceof String) {
            return Slices.wrappedBuffer((byte[])((String)value).getBytes(Charsets.UTF_8));
        }
        return value;
    }
}

