/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.OpCodes;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.control.LookupSwitch;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.BootstrapFunctionBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.FunctionBinder;
import com.facebook.presto.sql.gen.FunctionBinding;
import com.facebook.presto.sql.gen.LikeFunctionBinder;
import com.facebook.presto.sql.gen.SliceConstant;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ByteCodeExpressionVisitor
extends AstVisitor<ByteCodeNode, CompilerContext> {
    private final Metadata metadata;
    private final BootstrapFunctionBinder bootstrapFunctionBinder;
    private final Map<Expression, Type> expressionTypes;
    private final ByteCodeNode getSessionByteCode;
    private final boolean sourceIsCursor;
    private final TimeZoneKey timeZoneKey;

    public ByteCodeExpressionVisitor(Metadata metadata, BootstrapFunctionBinder bootstrapFunctionBinder, Map<Expression, Type> expressionTypes, ByteCodeNode getSessionByteCode, boolean sourceIsCursor, TimeZoneKey timeZoneKey) {
        this.metadata = metadata;
        this.bootstrapFunctionBinder = bootstrapFunctionBinder;
        this.expressionTypes = expressionTypes;
        this.getSessionByteCode = getSessionByteCode;
        this.sourceIsCursor = sourceIsCursor;
        this.timeZoneKey = timeZoneKey;
    }

    protected ByteCodeNode visitBooleanLiteral(BooleanLiteral node, CompilerContext context) {
        return Constant.loadBoolean(node.getValue());
    }

    protected ByteCodeNode visitLongLiteral(LongLiteral node, CompilerContext context) {
        return Constant.loadLong(node.getValue());
    }

    protected ByteCodeNode visitDoubleLiteral(DoubleLiteral node, CompilerContext context) {
        return Constant.loadDouble(node.getValue());
    }

    protected ByteCodeNode visitStringLiteral(StringLiteral node, CompilerContext context) {
        return SliceConstant.sliceConstant(node.getSlice());
    }

    protected ByteCodeNode visitNullLiteral(NullLiteral node, CompilerContext context) {
        return new Block(context).putVariable("wasNull", true);
    }

    protected ByteCodeNode visitGenericLiteral(GenericLiteral node, CompilerContext context) {
        Type type = this.metadata.getType(node.getType());
        if (type == null) {
            throw new IllegalArgumentException("Unsupported type: " + node.getType());
        }
        SliceConstant value = SliceConstant.sliceConstant(node.getValue());
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindCastOperator(this.getSessionByteCode, value, (Type)VarcharType.VARCHAR, type);
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected ByteCodeNode visitTimestampLiteral(TimestampLiteral node, CompilerContext context) {
        long value = this.expressionTypes.get(node).equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) ? DateTimeUtils.parseTimestampWithTimeZone(node.getValue()) : DateTimeUtils.parseTimestampWithoutTimeZone(this.timeZoneKey, node.getValue());
        return Constant.loadLong(value);
    }

    protected ByteCodeNode visitTimeLiteral(TimeLiteral node, CompilerContext context) {
        long value = this.expressionTypes.get(node).equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) ? DateTimeUtils.parseTimeWithTimeZone(node.getValue()) : DateTimeUtils.parseTimeWithoutTimeZone(this.timeZoneKey, node.getValue());
        return Constant.loadLong(value);
    }

    protected ByteCodeNode visitIntervalLiteral(IntervalLiteral node, CompilerContext context) {
        if (node.isYearToMonth()) {
            return Constant.loadLong((long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()));
        }
        return Constant.loadLong((long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField()));
    }

    public ByteCodeNode visitInputReference(InputReference node, CompilerContext context) {
        Input input = node.getInput();
        int channel = input.getChannel();
        Type type = this.expressionTypes.get(node);
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"No type for input %s", (Object[])new Object[]{input});
        Class javaType = type.getJavaType();
        if (this.sourceIsCursor) {
            Block isNullCheck = new Block(context).setDescription(String.format("cursor.get%s(%d)", type, channel)).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, Integer.TYPE);
            Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(javaType);
            if (javaType == Boolean.TYPE) {
                Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getBoolean", Boolean.TYPE, Integer.TYPE);
                return new IfStatement(context, isNullCheck, isNull, isNotNull);
            }
            if (javaType == Long.TYPE) {
                Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getLong", Long.TYPE, Integer.TYPE);
                return new IfStatement(context, isNullCheck, isNull, isNotNull);
            }
            if (javaType == Double.TYPE) {
                Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getDouble", Double.TYPE, Integer.TYPE);
                return new IfStatement(context, isNullCheck, isNull, isNotNull);
            }
            if (javaType == Slice.class) {
                Block isNotNull = new Block(context).getVariable("cursor").push(channel).invokeInterface(RecordCursor.class, "getSlice", Slice.class, Integer.TYPE);
                return new IfStatement(context, isNullCheck, isNull, isNotNull);
            }
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        Block isNullCheck = new Block(context).setDescription(String.format("channel_%d.get%s()", channel, type)).getVariable("channel_" + channel).invokeInterface(BlockCursor.class, "isNull", Boolean.TYPE, new Class[0]);
        Block isNull = new Block(context).putVariable("wasNull", true).pushJavaDefault(javaType);
        if (javaType == Boolean.TYPE) {
            Block isNotNull = new Block(context).getVariable("channel_" + channel).invokeInterface(BlockCursor.class, "getBoolean", Boolean.TYPE, new Class[0]);
            return new IfStatement(context, isNullCheck, isNull, isNotNull);
        }
        if (javaType == Long.TYPE) {
            Block isNotNull = new Block(context).getVariable("channel_" + channel).invokeInterface(BlockCursor.class, "getLong", Long.TYPE, new Class[0]);
            return new IfStatement(context, isNullCheck, isNull, isNotNull);
        }
        if (javaType == Double.TYPE) {
            Block isNotNull = new Block(context).getVariable("channel_" + channel).invokeInterface(BlockCursor.class, "getDouble", Double.TYPE, new Class[0]);
            return new IfStatement(context, isNullCheck, isNull, isNotNull);
        }
        if (javaType == Slice.class) {
            Block isNotNull = new Block(context).getVariable("channel_" + channel).invokeInterface(BlockCursor.class, "getSlice", Slice.class, new Class[0]);
            return new IfStatement(context, isNullCheck, isNull, isNotNull);
        }
        throw new UnsupportedOperationException("not yet implemented: " + type);
    }

    protected ByteCodeNode visitFunctionCall(FunctionCall node, CompilerContext context) {
        ArrayList<ByteCodeNode> arguments = new ArrayList<ByteCodeNode>();
        ArrayList<Type> argumentTypes = new ArrayList<Type>();
        for (Expression argument : node.getArguments()) {
            arguments.add((ByteCodeNode)this.process((Node)argument, context));
            argumentTypes.add(this.expressionTypes.get(argument));
        }
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindFunction(node.getName(), this.getSessionByteCode, arguments, argumentTypes);
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected ByteCodeNode visitLikePredicate(LikePredicate node, CompilerContext context) {
        ImmutableList expressions = node.getEscape() != null ? ImmutableList.of((Object)node.getValue(), (Object)node.getPattern(), (Object)node.getEscape()) : ImmutableList.of((Object)node.getValue(), (Object)node.getPattern());
        ArrayList<ByteCodeNode> arguments = new ArrayList<ByteCodeNode>();
        for (Expression argument : expressions) {
            arguments.add((ByteCodeNode)this.process((Node)argument, context));
        }
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindFunction("like", this.getSessionByteCode, arguments, new LikeFunctionBinder());
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    private ByteCodeNode visitFunctionBinding(CompilerContext context, FunctionBinding functionBinding, String comment) {
        List<ByteCodeNode> arguments = functionBinding.getArguments();
        MethodType methodType = functionBinding.getCallSite().type();
        Class unboxedReturnType = Primitives.unwrap((Class)methodType.returnType());
        LabelNode end = new LabelNode("end");
        Block block = new Block(context).setDescription("invoke").comment(comment);
        ArrayList<TypeDescriptor.OfField> stackTypes = new ArrayList<TypeDescriptor.OfField>();
        for (int i = 0; i < arguments.size(); ++i) {
            block.append(arguments.get(i));
            stackTypes.add(methodType.parameterType(i));
            block.append(this.ifWasNullPopAndGoto(context, end, unboxedReturnType, Lists.reverse(stackTypes)));
        }
        block.invokeDynamic(functionBinding.getName(), methodType, functionBinding.getBindingId());
        if (functionBinding.isNullable()) {
            if (unboxedReturnType.isPrimitive()) {
                LabelNode notNull = new LabelNode("notNull");
                block.dup((Class<?>)methodType.returnType()).ifNotNullGoto(notNull).putVariable("wasNull", true).comment("swap boxed null with unboxed default").pop((Class<?>)methodType.returnType()).pushJavaDefault(unboxedReturnType).gotoLabel(end).visitLabel(notNull).append(ByteCodeExpressionVisitor.unboxPrimitive(context, unboxedReturnType));
            } else {
                block.dup((Class<?>)methodType.returnType()).ifNotNullGoto(end).putVariable("wasNull", true);
            }
        }
        block.visitLabel(end);
        return block;
    }

    private static ByteCodeNode unboxPrimitive(CompilerContext context, Class<?> unboxedType) {
        Block block = new Block(context).comment("unbox primitive");
        if (unboxedType == Long.TYPE) {
            return block.invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
        }
        if (unboxedType == Double.TYPE) {
            return block.invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
        }
        if (unboxedType == Boolean.TYPE) {
            return block.invokeVirtual(Boolean.class, "booleanValue", Boolean.TYPE, new Class[0]);
        }
        throw new UnsupportedOperationException("not yet implemented: " + unboxedType);
    }

    public ByteCodeNode visitCast(Cast node, CompilerContext context) {
        Type type = this.metadata.getType(node.getType());
        if (type == null) {
            throw new IllegalArgumentException("Unsupported type: " + node.getType());
        }
        if (this.expressionTypes.get(node.getExpression()).equals(UnknownType.UNKNOWN)) {
            return new Block(context).putVariable("wasNull", true).pushJavaDefault(type.getJavaType());
        }
        ByteCodeNode value = (ByteCodeNode)this.process((Node)node.getExpression(), context);
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindCastOperator(this.getSessionByteCode, value, this.expressionTypes.get(node.getExpression()), type);
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected ByteCodeNode visitArithmeticExpression(ArithmeticExpression node, CompilerContext context) {
        ByteCodeNode left = (ByteCodeNode)this.process((Node)node.getLeft(), context);
        ByteCodeNode right = (ByteCodeNode)this.process((Node)node.getRight(), context);
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindOperator(OperatorType.valueOf(node.getType().name()), this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)left, (Object)right), this.types(node.getLeft(), node.getRight()));
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected ByteCodeNode visitNegativeExpression(NegativeExpression node, CompilerContext context) {
        ByteCodeNode value = (ByteCodeNode)this.process((Node)node.getValue(), context);
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindOperator(OperatorType.NEGATION, this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)value), this.types(node.getValue()));
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected ByteCodeNode visitLogicalBinaryExpression(LogicalBinaryExpression node, CompilerContext context) {
        ByteCodeNode left = (ByteCodeNode)this.process((Node)node.getLeft(), context);
        Type leftType = this.expressionTypes.get(node.getLeft());
        ByteCodeNode right = (ByteCodeNode)this.process((Node)node.getRight(), context);
        Type rightType = this.expressionTypes.get(node.getRight());
        switch (node.getType()) {
            case AND: {
                return this.visitAnd(context, left, leftType, right, rightType, node.toString());
            }
            case OR: {
                return this.visitOr(context, left, leftType, right, rightType, node.toString());
            }
        }
        throw new UnsupportedOperationException(String.format("not yet implemented: %s(%s, %s)", node.getType(), leftType, rightType));
    }

    private ByteCodeNode visitAnd(CompilerContext context, ByteCodeNode left, Type leftType, ByteCodeNode right, Type rightType, String comment) {
        Block block = new Block(context).comment(comment).setDescription("AND");
        block.append(left);
        IfStatement.IfStatementBuilder ifLeftIsNull = IfStatement.ifStatementBuilder(context).comment("if left wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue(new Block(context).comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").putVariable("wasNull", false).pop(leftType.getJavaType()).push(true));
        LabelNode leftIsTrue = new LabelNode("leftIsTrue");
        ifLeftIsNull.ifFalse(new Block(context).comment("if left is false, push false, and goto end").ifTrueGoto(leftIsTrue).push(false).gotoLabel(end).comment("left was true; push left null flag on the stack (false)").visitLabel(leftIsTrue).push(false));
        block.append(ifLeftIsNull.build());
        block.append(right);
        IfStatement.IfStatementBuilder ifRightIsNull = IfStatement.ifStatementBuilder(context).comment("if right wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        ifRightIsNull.ifTrue(new Block(context).comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(rightType.getJavaType()));
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse(new Block(context).comment("if right is false, pop left null flag off stack, push false and goto end").ifTrueGoto(rightIsTrue).pop(Boolean.TYPE).push(false).gotoLabel(end).comment("right was true; store left null flag (on stack) in wasNull variable, and push true").visitLabel(rightIsTrue).putVariable("wasNull").push(true));
        block.append(ifRightIsNull.build()).visitLabel(end);
        return block;
    }

    private ByteCodeNode visitOr(CompilerContext context, ByteCodeNode left, Type leftType, ByteCodeNode right, Type rightType, String comment) {
        Block block = new Block(context).comment(comment).setDescription("OR");
        block.append(left);
        IfStatement.IfStatementBuilder ifLeftIsNull = IfStatement.ifStatementBuilder(context).comment("if left wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        LabelNode end = new LabelNode("end");
        ifLeftIsNull.ifTrue(new Block(context).comment("clear the null flag, pop left value off stack, and push left null flag on the stack (true)").putVariable("wasNull", false).pop(leftType.getJavaType()).push(true));
        LabelNode leftIsFalse = new LabelNode("leftIsFalse");
        ifLeftIsNull.ifFalse(new Block(context).comment("if left is true, push true, and goto end").ifFalseGoto(leftIsFalse).push(true).gotoLabel(end).comment("left was false; push left null flag on the stack (false)").visitLabel(leftIsFalse).push(false));
        block.append(ifLeftIsNull.build());
        block.append(right);
        IfStatement.IfStatementBuilder ifRightIsNull = IfStatement.ifStatementBuilder(context).comment("if right wasNull...", new Object[0]).condition(new Block(context).getVariable("wasNull"));
        ifRightIsNull.ifTrue(new Block(context).comment("right was null, pop the right value off the stack; wasNull flag remains set to TRUE").pop(rightType.getJavaType()));
        LabelNode rightIsTrue = new LabelNode("rightIsTrue");
        ifRightIsNull.ifFalse(new Block(context).comment("if right is true, pop left null flag off stack, push true and goto end").ifFalseGoto(rightIsTrue).pop(Boolean.TYPE).push(true).gotoLabel(end).comment("right was false; store left null flag (on stack) in wasNull variable, and push false").visitLabel(rightIsTrue).putVariable("wasNull").push(false));
        block.append(ifRightIsNull.build()).visitLabel(end);
        return block;
    }

    protected ByteCodeNode visitNotExpression(NotExpression node, CompilerContext context) {
        ByteCodeNode value = (ByteCodeNode)this.process((Node)node.getValue(), context);
        return new Block(context).comment(node.toString()).append(value).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE);
    }

    protected ByteCodeNode visitComparisonExpression(ComparisonExpression node, CompilerContext context) {
        if (node.getType() == ComparisonExpression.Type.IS_DISTINCT_FROM) {
            return this.visitIsDistinctFrom(node, context);
        }
        ByteCodeNode left = (ByteCodeNode)this.process((Node)node.getLeft(), context);
        ByteCodeNode right = (ByteCodeNode)this.process((Node)node.getRight(), context);
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindOperator(OperatorType.valueOf(node.getType().name()), this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)left, (Object)right), this.types(node.getLeft(), node.getRight()));
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    private ByteCodeNode visitIsDistinctFrom(ComparisonExpression node, CompilerContext context) {
        Type leftType = this.expressionTypes.get(node.getLeft());
        Type rightType = this.expressionTypes.get(node.getRight());
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindOperator(OperatorType.EQUAL, this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)OpCodes.NOP, (Object)OpCodes.NOP), (List<Type>)ImmutableList.of((Object)leftType, (Object)rightType));
        Block equalsCall = new Block(context).comment("equals(%s, %s)", leftType, rightType).invokeDynamic(functionBinding.getName(), functionBinding.getCallSite().type(), functionBinding.getBindingId());
        Block block = new Block(context).comment(node.toString()).comment("left").append((ByteCodeNode)this.process((Node)node.getLeft(), context)).append(new IfStatement(context, new Block(context).getVariable("wasNull"), new Block(context).pop(leftType.getJavaType()).putVariable("wasNull", false).comment("right is not null").append((ByteCodeNode)this.process((Node)node.getRight(), context)).pop(rightType.getJavaType()).getVariable("wasNull").invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE), new Block(context).comment("right").append((ByteCodeNode)this.process((Node)node.getRight(), context)).append(new IfStatement(context, new Block(context).getVariable("wasNull"), new Block(context).pop(leftType.getJavaType()).pop(rightType.getJavaType()).push(true), new Block(context).append(equalsCall).invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE))))).putVariable("wasNull", false);
        return block;
    }

    protected ByteCodeNode visitBetweenPredicate(BetweenPredicate node, CompilerContext context) {
        ByteCodeNode value = (ByteCodeNode)this.process((Node)node.getValue(), context);
        ByteCodeNode min = (ByteCodeNode)this.process((Node)node.getMin(), context);
        ByteCodeNode max = (ByteCodeNode)this.process((Node)node.getMax(), context);
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindOperator(OperatorType.BETWEEN, this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)value, (Object)min, (Object)max), this.types(node.getValue(), node.getMin(), node.getMax()));
        return this.visitFunctionBinding(context, functionBinding, node.toString());
    }

    protected ByteCodeNode visitIsNullPredicate(IsNullPredicate node, CompilerContext context) {
        Type valueType = this.expressionTypes.get(node.getValue());
        if (valueType.equals(UnknownType.UNKNOWN)) {
            return Constant.loadBoolean(true);
        }
        ByteCodeNode value = (ByteCodeNode)this.process((Node)node.getValue(), context);
        Block block = new Block(context).comment(node.toString()).append(value).pop(valueType.getJavaType()).getVariable("wasNull");
        block.putVariable("wasNull", false);
        return block;
    }

    protected ByteCodeNode visitSearchedCaseExpression(SearchedCaseExpression node, final CompilerContext context) {
        Type type = this.expressionTypes.get(node);
        ByteCodeNode elseValue = node.getDefaultValue() != null ? (ByteCodeNode)this.process((Node)node.getDefaultValue(), context) : this.typedNull(context, type.getJavaType());
        ImmutableList whenClauses = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)node.getWhenClauses(), (Function)new Function<WhenClause, TypedWhenClause>(){

            public TypedWhenClause apply(WhenClause whenClause) {
                return new TypedWhenClause(context, whenClause);
            }
        }));
        for (TypedWhenClause whenClause : Lists.reverse(new ArrayList(whenClauses))) {
            Block condition = new Block(context).append(whenClause.operandBlock).comment("... and condition value was not null").getVariable("wasNull").invokeStatic(CompilerOperations.class, "not", Boolean.TYPE, Boolean.TYPE).invokeStatic(CompilerOperations.class, "and", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE).putVariable("wasNull", false);
            elseValue = new IfStatement(context, condition, whenClause.valueBlock, elseValue);
        }
        return elseValue;
    }

    protected ByteCodeNode visitSimpleCaseExpression(SimpleCaseExpression node, final CompilerContext context) {
        ByteCodeNode value = (ByteCodeNode)this.process((Node)node.getOperand(), context);
        Type type = this.expressionTypes.get(node);
        ByteCodeNode elseValue = node.getDefaultValue() != null ? (ByteCodeNode)this.process((Node)node.getDefaultValue(), context) : this.typedNull(context, type.getJavaType());
        ImmutableList whenClauses = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)node.getWhenClauses(), (Function)new Function<WhenClause, TypedWhenClause>(){

            public TypedWhenClause apply(WhenClause whenClause) {
                return new TypedWhenClause(context, whenClause);
            }
        }));
        Class valueType = this.expressionTypes.get(node.getOperand()).getJavaType();
        LabelNode nullValue = new LabelNode("nullCondition");
        Variable tempVariable = context.createTempVariable(valueType);
        Block block = new Block(context).append(value).append(this.ifWasNullClearPopAndGoto(context, nullValue, Void.TYPE, valueType)).putVariable(tempVariable.getLocalVariableDefinition());
        InstructionNode getTempVariableNode = VariableInstruction.loadVariable(tempVariable.getLocalVariableDefinition());
        elseValue = new Block(context).visitLabel(nullValue).append(elseValue);
        for (TypedWhenClause whenClause : Lists.reverse(new ArrayList(whenClauses))) {
            FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindOperator(OperatorType.EQUAL, this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)whenClause.operandBlock, (Object)getTempVariableNode), this.types(whenClause.operand, node.getOperand()));
            ByteCodeNode equalsCall = this.visitFunctionBinding(context, functionBinding, whenClause.operand.toString());
            Block condition = new Block(context).append(equalsCall).putVariable("wasNull", false);
            elseValue = new IfStatement(context, String.format("when %s", whenClause.operand), condition, whenClause.valueBlock, elseValue);
        }
        return block.append(elseValue);
    }

    protected ByteCodeNode visitNullIfExpression(NullIfExpression node, CompilerContext context) {
        ByteCodeNode first = (ByteCodeNode)this.process((Node)node.getFirst(), context);
        Type firstType = this.expressionTypes.get(node.getFirst());
        ByteCodeNode second = (ByteCodeNode)this.process((Node)node.getSecond(), context);
        LabelNode notMatch = new LabelNode("notMatch");
        Block block = new Block(context).comment(node.toString()).append(first).append(this.ifWasNullPopAndGoto(context, notMatch, Void.TYPE, new Class[0]));
        FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindOperator(OperatorType.EQUAL, this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)new Block(context).dup(firstType.getJavaType()), (Object)second), this.types(node.getFirst(), node.getSecond()));
        ByteCodeNode equalsCall = this.visitFunctionBinding(context, functionBinding, "equal");
        Block conditionBlock = new Block(context).append(equalsCall).append(this.ifWasNullClearPopAndGoto(context, notMatch, Void.TYPE, Boolean.TYPE));
        Block trueBlock = new Block(context).putVariable("wasNull", true).pop(firstType.getJavaType()).pushJavaDefault(firstType.getJavaType());
        block.append(new IfStatement(context, conditionBlock, trueBlock, notMatch));
        return block;
    }

    protected ByteCodeNode visitCoalesceExpression(CoalesceExpression node, CompilerContext context) {
        ArrayList<Object> operands = new ArrayList<Object>();
        for (Expression expression : node.getOperands()) {
            operands.add(this.process((Node)expression, context));
        }
        Class type = this.expressionTypes.get(node).getJavaType();
        ByteCodeNode nullValue = this.typedNull(context, type);
        for (ByteCodeNode operand : Lists.reverse(operands)) {
            Block condition = new Block(context).append(operand).getVariable("wasNull");
            Block nullBlock = new Block(context).pop(type).putVariable("wasNull", false).append(nullValue);
            nullValue = new IfStatement(context, condition, nullBlock, OpCodes.NOP);
        }
        return nullValue;
    }

    protected ByteCodeNode visitInPredicate(InPredicate node, CompilerContext context) {
        Block switchBlock;
        Expression valueListExpression = node.getValueList();
        if (!(valueListExpression instanceof InListExpression)) {
            throw new UnsupportedOperationException("Compilation of IN subquery is not supported yet");
        }
        ByteCodeNode value = (ByteCodeNode)this.process((Node)node.getValue(), context);
        ImmutableList.Builder values = ImmutableList.builder();
        InListExpression valueList = (InListExpression)valueListExpression;
        for (Expression test : valueList.getValues()) {
            ByteCodeNode testNode = (ByteCodeNode)this.process((Node)test, context);
            values.add((Object)testNode);
        }
        Type type = this.expressionTypes.get(node.getValue());
        Class javaType = type.getJavaType();
        FunctionBinding hashCodeFunction = this.bootstrapFunctionBinder.bindOperator(OperatorType.HASH_CODE, this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)OpCodes.NOP), (List<Type>)ImmutableList.of((Object)type));
        ImmutableListMultimap.Builder hashBucketsBuilder = ImmutableListMultimap.builder();
        ImmutableList.Builder defaultBucket = ImmutableList.builder();
        ImmutableSet.Builder constantValuesBuilder = ImmutableSet.builder();
        for (ByteCodeNode testNode : values.build()) {
            if (testNode instanceof Constant) {
                int hashCode;
                Constant constant = (Constant)testNode;
                Object testValue = constant.getValue();
                constantValuesBuilder.add(testValue);
                if (javaType == Boolean.TYPE) {
                    testValue = ((Number)testValue).intValue() != 0;
                }
                try {
                    hashCode = hashCodeFunction.getCallSite().dynamicInvoker().invoke(testValue);
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Error processing IN statement: error calculating hash code for " + testValue, throwable);
                }
                hashBucketsBuilder.put((Object)hashCode, (Object)testNode);
                continue;
            }
            defaultBucket.add((Object)testNode);
        }
        ImmutableListMultimap hashBuckets = hashBucketsBuilder.build();
        ImmutableSet constantValues = constantValuesBuilder.build();
        LabelNode end = new LabelNode("end");
        LabelNode match = new LabelNode("match");
        LabelNode noMatch = new LabelNode("noMatch");
        LabelNode defaultLabel = new LabelNode("default");
        if (constantValues.size() < 1000) {
            Block switchCaseBlocks = new Block(context);
            LookupSwitch.LookupSwitchBuilder switchBuilder = LookupSwitch.lookupSwitchBuilder();
            for (Map.Entry bucket : hashBuckets.asMap().entrySet()) {
                LabelNode label = new LabelNode("inHash" + bucket.getKey());
                switchBuilder.addCase((Integer)bucket.getKey(), label);
                Collection testValues = (Collection)bucket.getValue();
                Block caseBlock = this.buildInCase(context, type, label, match, defaultLabel, testValues, false);
                switchCaseBlocks.append(caseBlock.setDescription("case " + bucket.getKey()));
            }
            switchBuilder.defaultCase(defaultLabel);
            switchBlock = new Block(context).comment("lookupSwitch(hashCode(<stackValue>))").dup(javaType).invokeDynamic(hashCodeFunction.getName(), hashCodeFunction.getCallSite().type(), hashCodeFunction.getBindingId()).append(switchBuilder.build()).append(switchCaseBlocks);
        } else {
            FunctionBinding functionBinding = this.bootstrapFunctionBinder.bindFunction("in", this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of(), new InFunctionBinder(javaType, (ImmutableSet<Object>)constantValues));
            switchBlock = new Block(context).comment("inListSet.contains(<stackValue>)").append(new IfStatement(context, new Block(context).dup(javaType).invokeDynamic(functionBinding.getName(), functionBinding.getCallSite().type(), functionBinding.getBindingId()), JumpInstruction.jump(match), OpCodes.NOP));
        }
        Block defaultCaseBlock = this.buildInCase(context, type, defaultLabel, match, noMatch, (Collection<ByteCodeNode>)defaultBucket.build(), true).setDescription("default");
        Block block = new Block(context).comment(node.toString()).append(value).append(this.ifWasNullPopAndGoto(context, end, Boolean.TYPE, javaType)).append(switchBlock).append(defaultCaseBlock);
        Block matchBlock = new Block(context).setDescription("match").visitLabel(match).pop(javaType).putVariable("wasNull", false).push(true).gotoLabel(end);
        block.append(matchBlock);
        Block noMatchBlock = new Block(context).setDescription("noMatch").visitLabel(noMatch).pop(javaType).push(false).gotoLabel(end);
        block.append(noMatchBlock);
        block.visitLabel(end);
        return block;
    }

    private Block buildInCase(CompilerContext context, Type type, LabelNode caseLabel, LabelNode matchLabel, LabelNode noMatchLabel, Collection<ByteCodeNode> testValues, boolean checkForNulls) {
        Variable caseWasNull = null;
        if (checkForNulls) {
            caseWasNull = context.createTempVariable(Boolean.TYPE);
        }
        Block caseBlock = new Block(context).visitLabel(caseLabel);
        if (checkForNulls) {
            caseBlock.putVariable(caseWasNull.getLocalVariableDefinition(), false);
        }
        LabelNode elseLabel = new LabelNode("else");
        Block elseBlock = new Block(context).visitLabel(elseLabel);
        if (checkForNulls) {
            elseBlock.getVariable(caseWasNull.getLocalVariableDefinition()).putVariable("wasNull");
        }
        elseBlock.gotoLabel(noMatchLabel);
        FunctionBinding equalsFunction = this.bootstrapFunctionBinder.bindOperator(OperatorType.EQUAL, this.getSessionByteCode, (List<ByteCodeNode>)ImmutableList.of((Object)OpCodes.NOP, (Object)OpCodes.NOP), (List<Type>)ImmutableList.of((Object)type, (Object)type));
        ByteCodeNode elseNode = elseBlock;
        for (ByteCodeNode testNode : testValues) {
            LabelNode testLabel = new LabelNode("test");
            IfStatement.IfStatementBuilder test = IfStatement.ifStatementBuilder(context);
            Block condition = new Block(context).visitLabel(testLabel).dup(type.getJavaType()).append(testNode);
            if (checkForNulls) {
                condition.getVariable("wasNull").putVariable(caseWasNull.getLocalVariableDefinition()).append(this.ifWasNullPopAndGoto(context, elseLabel, Void.TYPE, type.getJavaType(), type.getJavaType()));
            }
            condition.invokeDynamic(equalsFunction.getName(), equalsFunction.getCallSite().type(), equalsFunction.getBindingId());
            test.condition(condition);
            test.ifTrue(new Block(context).gotoLabel(matchLabel));
            test.ifFalse(elseNode);
            elseNode = test.build();
            elseLabel = testLabel;
        }
        caseBlock.append(elseNode);
        return caseBlock;
    }

    protected ByteCodeNode visitExpression(Expression node, CompilerContext context) {
        throw new UnsupportedOperationException(String.format("Compilation of %s not supported yet", node.getClass().getSimpleName()));
    }

    private ByteCodeNode ifWasNullPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return this.handleNullValue(context, label, returnType, (List<? extends Class<?>>)ImmutableList.copyOf((Object[])stackArgsToPop), false);
    }

    private ByteCodeNode ifWasNullPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Iterable<? extends Class<?>> stackArgsToPop) {
        return this.handleNullValue(context, label, returnType, (List<? extends Class<?>>)ImmutableList.copyOf(stackArgsToPop), false);
    }

    private ByteCodeNode ifWasNullClearPopAndGoto(CompilerContext context, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return this.handleNullValue(context, label, returnType, (List<? extends Class<?>>)ImmutableList.copyOf((Object[])stackArgsToPop), true);
    }

    private ByteCodeNode handleNullValue(CompilerContext context, LabelNode label, Class<?> returnType, List<? extends Class<?>> stackArgsToPop, boolean clearNullFlag) {
        Block nullCheck = new Block(context).setDescription("ifWasNullGoto").getVariable("wasNull");
        String clearComment = null;
        if (clearNullFlag) {
            nullCheck.putVariable("wasNull", false);
            clearComment = "clear wasNull";
        }
        Block isNull = new Block(context);
        for (Class<?> parameterType : stackArgsToPop) {
            isNull.pop(parameterType);
        }
        isNull.pushJavaDefault(returnType);
        String loadDefaultComment = null;
        if (returnType != Void.TYPE) {
            loadDefaultComment = String.format("loadJavaDefault(%s)", returnType.getName());
        }
        isNull.gotoLabel(label);
        String popComment = null;
        if (!stackArgsToPop.isEmpty()) {
            popComment = String.format("pop(%s)", Joiner.on((String)", ").join(stackArgsToPop));
        }
        String comment = String.format("if wasNull then %s", Joiner.on((String)", ").skipNulls().join((Object)clearComment, (Object)popComment, new Object[]{loadDefaultComment, "goto " + label.getLabel()}));
        return new IfStatement(context, comment, nullCheck, isNull, OpCodes.NOP);
    }

    private ByteCodeNode typedNull(CompilerContext context, Class<?> type) {
        return new Block(context).putVariable("wasNull", true).pushJavaDefault(type);
    }

    private List<Type> types(Expression ... types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf((Object[])types), (Function)Functions.forMap(this.expressionTypes)));
    }

    private class TypedWhenClause {
        private final Expression operand;
        private final ByteCodeNode operandBlock;
        private final Expression result;
        private final ByteCodeNode valueBlock;

        private TypedWhenClause(CompilerContext context, WhenClause whenClause) {
            this.operand = whenClause.getOperand();
            this.operandBlock = (ByteCodeNode)ByteCodeExpressionVisitor.this.process((Node)this.operand, context);
            this.result = whenClause.getResult();
            this.valueBlock = (ByteCodeNode)ByteCodeExpressionVisitor.this.process((Node)this.result, context);
        }
    }

    public static class InFunctionBinder
    implements FunctionBinder {
        private static final MethodHandle inMethod;
        private final Class<?> valueType;
        private final ImmutableSet<Object> constantValues;

        public InFunctionBinder(Class<?> valueType, ImmutableSet<Object> constantValues) {
            this.valueType = valueType;
            this.constantValues = constantValues;
        }

        @Override
        public FunctionBinding bindFunction(long bindingId, String name, ByteCodeNode getSessionByteCode, List<ByteCodeNode> arguments) {
            MethodHandle methodHandle = inMethod.bindTo(this.constantValues);
            methodHandle = methodHandle.asType(MethodType.methodType(Boolean.TYPE, this.valueType));
            return new FunctionBinding(bindingId, name, new ConstantCallSite(methodHandle), arguments, false);
        }

        public static boolean in(ImmutableSet<?> set, Object value) {
            return set.contains(value);
        }

        static {
            try {
                inMethod = MethodHandles.lookup().findStatic(InFunctionBinder.class, "in", MethodType.methodType(Boolean.TYPE, ImmutableSet.class, Object.class));
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

