/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.Optionals;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TupleDescriptor {
    private final List<Field> visibleFields;
    private final List<Field> allFields;

    public TupleDescriptor(Field ... fields) {
        this((List<Field>)ImmutableList.copyOf((Object[])fields));
    }

    public TupleDescriptor(List<Field> fields) {
        Preconditions.checkNotNull(fields, (Object)"fields is null");
        this.allFields = ImmutableList.copyOf(fields);
        this.visibleFields = ImmutableList.copyOf((Iterable)Iterables.filter(fields, Field.isVisiblePredicate()));
    }

    public int indexOf(Field field) {
        return this.allFields.indexOf(field);
    }

    public Field getFieldByIndex(int fieldIndex) {
        Preconditions.checkElementIndex((int)fieldIndex, (int)this.allFields.size(), (String)"fieldIndex");
        return this.allFields.get(fieldIndex);
    }

    public Collection<Field> getVisibleFields() {
        return this.visibleFields;
    }

    public int getVisibleFieldCount() {
        return this.visibleFields.size();
    }

    public Collection<Field> getAllFields() {
        return ImmutableSet.copyOf(this.allFields);
    }

    public int getAllFieldCount() {
        return this.allFields.size();
    }

    public Set<QualifiedName> getRelationAliases() {
        return IterableTransformer.on(this.allFields).transform(Field.relationAliasGetter()).select(Optionals.isPresentPredicate()).transform(Optionals.optionalGetter()).set();
    }

    public List<Field> resolveFieldsWithPrefix(Optional<QualifiedName> prefix) {
        return IterableTransformer.on(this.visibleFields).select(Field.matchesPrefixPredicate(prefix)).list();
    }

    public List<Field> resolveFields(QualifiedName name) {
        return IterableTransformer.on(this.allFields).select(Field.canResolvePredicate(name)).list();
    }

    public Predicate<QualifiedName> canResolvePredicate() {
        return new Predicate<QualifiedName>(){

            public boolean apply(QualifiedName input) {
                return !TupleDescriptor.this.resolveFields(input).isEmpty();
            }
        };
    }

    public TupleDescriptor joinWith(TupleDescriptor other) {
        ImmutableList fields = ImmutableList.builder().addAll(this.allFields).addAll(other.allFields).build();
        return new TupleDescriptor((List<Field>)fields);
    }

    public TupleDescriptor withAlias(String relationAlias, List<String> columnAliases) {
        if (columnAliases != null) {
            Preconditions.checkArgument((columnAliases.size() == this.visibleFields.size() ? 1 : 0) != 0, (String)"Column alias list has %s entries but '%s' has %s columns available", (Object[])new Object[]{columnAliases.size(), relationAlias, this.visibleFields.size()});
        }
        ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
        for (int i = 0; i < this.allFields.size(); ++i) {
            Field field = this.allFields.get(i);
            Optional columnAlias = field.getName();
            if (columnAliases == null) {
                fieldsBuilder.add((Object)Field.newQualified(QualifiedName.of((String)relationAlias, (String[])new String[0]), (Optional<String>)columnAlias, field.getType(), field.isHidden()));
                continue;
            }
            if (field.isHidden()) continue;
            columnAlias = Optional.of((Object)columnAliases.get(i));
            fieldsBuilder.add((Object)Field.newQualified(QualifiedName.of((String)relationAlias, (String[])new String[0]), (Optional<String>)columnAlias, field.getType(), false));
        }
        return new TupleDescriptor((List<Field>)fieldsBuilder.build());
    }

    public TupleDescriptor withOnlyVisibleFields() {
        return new TupleDescriptor(this.visibleFields);
    }

    public String toString() {
        return this.allFields.toString();
    }
}

