/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class AggregateExtractor
extends DefaultExpressionTraversalVisitor<Void, Void> {
    private final Metadata metadata;
    private final ImmutableList.Builder<FunctionCall> aggregates = ImmutableList.builder();

    public AggregateExtractor(Metadata metadata) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.metadata = metadata;
    }

    protected Void visitFunctionCall(FunctionCall node, Void context) {
        if (this.metadata.isAggregationFunction(node.getName()) && !node.getWindow().isPresent()) {
            this.aggregates.add((Object)node);
            return null;
        }
        return (Void)super.visitFunctionCall(node, null);
    }

    public List<FunctionCall> getAggregates() {
        return this.aggregates.build();
    }
}

