/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.List;

public class MappedRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final int[] delegateFieldIndex;
    private final List<Type> columnTypes;

    public MappedRecordSet(RecordSet delegate, List<Integer> delegateFieldIndex) {
        this.delegate = delegate;
        this.delegateFieldIndex = new int[delegateFieldIndex.size()];
        for (int i = 0; i < delegateFieldIndex.size(); ++i) {
            this.delegateFieldIndex[i] = delegateFieldIndex.get(i);
        }
        List delegateColumnTypes = delegate.getColumnTypes();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        for (int delegateField : delegateFieldIndex) {
            Preconditions.checkArgument((delegateField >= 0 && delegateField < delegateColumnTypes.size() ? 1 : 0) != 0, (String)"Invalid system field %s", (Object[])new Object[]{delegateField});
            columnTypes.add(delegateColumnTypes.get(delegateField));
        }
        this.columnTypes = columnTypes.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new MappedRecordCursor(this.delegate.cursor(), this.delegateFieldIndex);
    }

    private static class MappedRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;
        private final int[] delegateFieldIndex;

        private MappedRecordCursor(RecordCursor delegate, int[] delegateFieldIndex) {
            this.delegate = delegate;
            this.delegateFieldIndex = delegateFieldIndex;
        }

        public long getTotalBytes() {
            return this.delegate.getTotalBytes();
        }

        public long getCompletedBytes() {
            return this.delegate.getCompletedBytes();
        }

        public long getReadTimeNanos() {
            return this.delegate.getReadTimeNanos();
        }

        public Type getType(int field) {
            return this.delegate.getType(this.toDelegateField(field));
        }

        public boolean advanceNextPosition() {
            return this.delegate.advanceNextPosition();
        }

        public boolean getBoolean(int field) {
            return this.delegate.getBoolean(this.toDelegateField(field));
        }

        public long getLong(int field) {
            return this.delegate.getLong(this.toDelegateField(field));
        }

        public double getDouble(int field) {
            return this.delegate.getDouble(this.toDelegateField(field));
        }

        public Slice getSlice(int field) {
            return this.delegate.getSlice(this.toDelegateField(field));
        }

        public boolean isNull(int field) {
            return this.delegate.isNull(this.toDelegateField(field));
        }

        public void close() {
            this.delegate.close();
        }

        private int toDelegateField(int field) {
            Preconditions.checkArgument((field >= 0 ? 1 : 0) != 0, (Object)"field is negative");
            Preconditions.checkArgument((field < this.delegateFieldIndex.length ? 1 : 0) != 0);
            return this.delegateFieldIndex[field];
        }
    }
}

