/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.server.HttpRemoteTask;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Node;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.collect.Multimap;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.AsyncHttpClient;
import io.airlift.http.client.HttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpRemoteTaskFactory
implements RemoteTaskFactory {
    private final AsyncHttpClient httpClient;
    private final LocationFactory locationFactory;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec;
    private final int maxConsecutiveErrorCount;
    private final Duration minErrorDuration;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remote-task-callback-%d"));
    private final ThreadPoolExecutorMBean executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executor);

    @Inject
    public HttpRemoteTaskFactory(QueryManagerConfig config, @ForScheduler AsyncHttpClient httpClient, LocationFactory locationFactory, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec) {
        this.httpClient = httpClient;
        this.locationFactory = locationFactory;
        this.taskInfoCodec = taskInfoCodec;
        this.taskUpdateRequestCodec = taskUpdateRequestCodec;
        this.maxConsecutiveErrorCount = config.getRemoteTaskMaxConsecutiveErrorCount();
        this.minErrorDuration = config.getRemoteTaskMinErrorDuration();
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Override
    public RemoteTask createRemoteTask(ConnectorSession session, TaskId taskId, Node node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers) {
        return new HttpRemoteTask(session, taskId, node.getNodeIdentifier(), this.locationFactory.createTaskLocation(node, taskId), fragment, initialSplits, outputBuffers, (HttpClient)this.httpClient, this.executor, this.maxConsecutiveErrorCount, this.minErrorDuration, this.taskInfoCodec, this.taskUpdateRequestCodec);
    }
}

