/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public class UncompressedEncoder
implements Encoder {
    private final SliceOutput sliceOutput;
    private BlockEncoding encoding;
    private BlockBuilder blockBuilder;
    private boolean finished;

    public UncompressedEncoder(SliceOutput sliceOutput) {
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
    }

    @Override
    public Encoder append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        if (this.encoding == null) {
            this.blockBuilder = block.getType().createBlockBuilder(new BlockBuilderStatus());
            this.encoding = this.blockBuilder.getEncoding();
        }
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            cursor.appendTo(this.blockBuilder);
            if (!this.blockBuilder.isFull()) continue;
            this.writeBlock();
        }
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.encoding != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        if (!this.blockBuilder.isEmpty()) {
            this.writeBlock();
        }
        return this.encoding;
    }

    private void writeBlock() {
        Block block = this.blockBuilder.build();
        this.encoding.writeBlock(this.sliceOutput, block);
        this.blockBuilder = block.getType().createBlockBuilder(new BlockBuilderStatus());
    }
}

