/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public final class TypeSerde {
    private TypeSerde() {
    }

    public static void writeInfo(SliceOutput sliceOutput, Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
        TypeSerde.writeLengthPrefixedString(sliceOutput, type.getName());
    }

    public static Type readType(TypeManager typeManager, SliceInput sliceInput) {
        Preconditions.checkNotNull((Object)sliceInput, (Object)"sliceInput is null");
        String name = TypeSerde.readLengthPrefixedString(sliceInput);
        Type type = typeManager.getType(name);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object[])new Object[]{name});
        return type;
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, Charsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String string) {
        byte[] bytes = string.getBytes(Charsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

