/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.rle.RunLengthBlockEncoding;
import com.facebook.presto.block.rle.RunLengthEncodedBlock;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public class RunLengthEncoder
implements Encoder {
    private final SliceOutput sliceOutput;
    private boolean finished;
    private int positionCount;
    private Block lastValue;
    private RunLengthBlockEncoding encoding;

    public RunLengthEncoder(SliceOutput sliceOutput) {
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
    }

    @Override
    public Encoder append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        if (this.encoding == null) {
            this.encoding = new RunLengthBlockEncoding(block.getEncoding());
        }
        BlockCursor cursor = block.cursor();
        while (cursor.advanceNextPosition()) {
            if (this.lastValue == null) {
                this.lastValue = cursor.getSingleValueBlock();
            } else if (!this.lastValue.equalTo(0, cursor)) {
                this.writeBlock();
                this.lastValue = cursor.getSingleValueBlock();
            }
            ++this.positionCount;
        }
        return this;
    }

    private void writeBlock() {
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(this.lastValue, this.positionCount);
        this.encoding.writeBlock(this.sliceOutput, block);
        this.lastValue = null;
        this.positionCount = 0;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.encoding != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        if (this.positionCount > 0) {
            this.writeBlock();
        }
        return this.encoding;
    }
}

