/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import java.util.Iterator;

public class EncodedBlockIterable
implements BlockIterable {
    private final BlockEncoding blockEncoding;
    private final Slice blocksSlice;
    private final int positionCount;

    public EncodedBlockIterable(BlockEncoding blockEncoding, Slice blocksSlice, int positionCount) {
        this.positionCount = positionCount;
        Preconditions.checkNotNull((Object)blockEncoding, (Object)"blockEncoding is null");
        Preconditions.checkNotNull((Object)blocksSlice, (Object)"blocksSlice is null");
        this.blockEncoding = blockEncoding;
        this.blocksSlice = blocksSlice;
    }

    @Override
    public Type getType() {
        return this.blockEncoding.getType();
    }

    @Override
    public Optional<DataSize> getDataSize() {
        return Optional.of((Object)new DataSize((double)this.blocksSlice.length(), DataSize.Unit.BYTE));
    }

    @Override
    public Optional<Integer> getPositionCount() {
        return Optional.of((Object)this.positionCount);
    }

    @Override
    public Iterator<Block> iterator() {
        return new EncodedBlockIterator(this.blockEncoding, (SliceInput)this.blocksSlice.getInput());
    }

    private static class EncodedBlockIterator
    extends AbstractIterator<Block> {
        private final BlockEncoding blockEncoding;
        private final SliceInput sliceInput;

        private EncodedBlockIterator(BlockEncoding blockEncoding, SliceInput sliceInput) {
            this.blockEncoding = blockEncoding;
            this.sliceInput = sliceInput;
        }

        protected Block computeNext() {
            if (!this.sliceInput.isReadable()) {
                return (Block)this.endOfData();
            }
            Block block = this.blockEncoding.readBlock(this.sliceInput);
            return block;
        }
    }
}

