/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import it.unimi.dsi.fastutil.ints.Int2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.ints.IntHash;

public class DictionaryBuilder {
    private static final int CURRENT_VALUE_POSITION = -1;
    private final BlockBuilder blockBuilder;
    private final BlockBuilderHashStrategy hashStrategy;
    private final Int2IntOpenCustomHashMap positions;
    private int nextPosition;

    public DictionaryBuilder(Type type) {
        this.blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        this.hashStrategy = new BlockBuilderHashStrategy();
        this.positions = new Int2IntOpenCustomHashMap(1024, (IntHash.Strategy)this.hashStrategy);
        this.positions.defaultReturnValue(-1);
    }

    public int size() {
        return this.positions.size();
    }

    public int putIfAbsent(BlockCursor value) {
        this.hashStrategy.setCurrentValue(value);
        int position = this.positions.get(-1);
        if (position < 0) {
            position = this.addNewValue(value);
        }
        return position;
    }

    public Block build() {
        return this.blockBuilder.build();
    }

    private int addNewValue(BlockCursor value) {
        int position = this.nextPosition++;
        value.appendTo(this.blockBuilder);
        this.positions.put(position, position);
        return position;
    }

    private class BlockBuilderHashStrategy
    implements IntHash.Strategy {
        private BlockCursor currentValue;

        private BlockBuilderHashStrategy() {
        }

        public void setCurrentValue(BlockCursor currentValue) {
            this.currentValue = currentValue;
        }

        public int hashCode(int offset) {
            if (offset == -1) {
                return this.hashCurrentRow();
            }
            return this.hashOffset(offset);
        }

        private int hashCurrentRow() {
            return this.currentValue.hash();
        }

        public int hashOffset(int offset) {
            return DictionaryBuilder.this.blockBuilder.hash(offset);
        }

        public boolean equals(int leftPosition, int rightPosition) {
            if (leftPosition == -1 && rightPosition == -1) {
                return true;
            }
            if (leftPosition == -1) {
                return this.offsetEqualsCurrentValue(rightPosition);
            }
            if (rightPosition == -1) {
                return this.offsetEqualsCurrentValue(leftPosition);
            }
            return this.offsetEqualsOffset(leftPosition, rightPosition);
        }

        public boolean offsetEqualsOffset(int leftOffset, int rightOffset) {
            return DictionaryBuilder.this.blockBuilder.equalTo(leftOffset, (Block)DictionaryBuilder.this.blockBuilder, rightOffset);
        }

        public boolean offsetEqualsCurrentValue(int offset) {
            return DictionaryBuilder.this.blockBuilder.equalTo(offset, this.currentValue);
        }
    }
}

