/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public final class StringFunctions {
    private StringFunctions() {
    }

    @Description(value="convert ASCII character code to string")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice chr(@SqlType(value=BigintType.class) long n) {
        Slice slice = Slices.allocate((int)1);
        slice.setByte(0, Ints.saturatedCast((long)n));
        return slice;
    }

    @Description(value="concatenates given strings")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice concat(@SqlType(value=VarcharType.class) Slice str1, @SqlType(value=VarcharType.class) Slice str2) {
        Slice concat = Slices.allocate((int)(str1.length() + str2.length()));
        concat.setBytes(0, str1);
        concat.setBytes(str1.length(), str2);
        return concat;
    }

    @Description(value="length of the given string")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long length(@SqlType(value=VarcharType.class) Slice slice) {
        return slice.length();
    }

    @Description(value="greedily removes occurrences of a pattern in a string")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice replace(@SqlType(value=VarcharType.class) Slice str, @SqlType(value=VarcharType.class) Slice search) {
        return StringFunctions.replace(str, search, Slices.EMPTY_SLICE);
    }

    @Description(value="greedily replaces occurrences of a pattern with a string")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice replace(@SqlType(value=VarcharType.class) Slice str, @SqlType(value=VarcharType.class) Slice search, @SqlType(value=VarcharType.class) Slice replace) {
        String replaced = str.toString(Charsets.UTF_8).replace(search.toString(Charsets.UTF_8), replace.toString(Charsets.UTF_8));
        return Slices.copiedBuffer((String)replaced, (Charset)Charsets.UTF_8);
    }

    @Description(value="reverses the given string")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice reverse(@SqlType(value=VarcharType.class) Slice slice) {
        Slice reverse = Slices.allocate((int)slice.length());
        int i = 0;
        int j = slice.length() - 1;
        while (i < slice.length()) {
            reverse.setByte(j, (int)slice.getByte(i));
            ++i;
            --j;
        }
        return reverse;
    }

    @Description(value="returns index of first occurrence of a substring (or 0 if not found)")
    @ScalarFunction(value="strpos")
    @SqlType(value=BigintType.class)
    public static long stringPosition(@SqlType(value=VarcharType.class) Slice string, @SqlType(value=VarcharType.class) Slice substring) {
        if (substring.length() > string.length()) {
            return 0L;
        }
        for (int i = 0; i <= string.length() - substring.length(); ++i) {
            if (!string.equals(i, substring.length(), substring, 0, substring.length())) continue;
            return i + 1;
        }
        return 0L;
    }

    @Description(value="suffix starting at given index")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice substr(@SqlType(value=VarcharType.class) Slice slice, @SqlType(value=BigintType.class) long start) {
        return StringFunctions.substr(slice, start, slice.length());
    }

    @Description(value="substring of given length starting at an index")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice substr(@SqlType(value=VarcharType.class) Slice slice, @SqlType(value=BigintType.class) long start, @SqlType(value=BigintType.class) long length) {
        if (start == 0L || length <= 0L) {
            return Slices.EMPTY_SLICE;
        }
        if (start > 0L) {
            --start;
        } else if ((start += (long)slice.length()) < 0L) {
            return Slices.EMPTY_SLICE;
        }
        if (start + length > (long)slice.length()) {
            length = (long)slice.length() - start;
        }
        if (start >= (long)slice.length()) {
            return Slices.EMPTY_SLICE;
        }
        return slice.slice((int)start, (int)length);
    }

    @Nullable
    @Description(value="splits a string by a delimiter and returns the specified field (counting from one)")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice splitPart(@SqlType(value=VarcharType.class) Slice string, @SqlType(value=VarcharType.class) Slice delimiter, @SqlType(value=BigintType.class) long index) {
        Preconditions.checkArgument((index > 0L ? 1 : 0) != 0, (Object)"Index must be greater than zero");
        if (delimiter.length() == 0) {
            if (index > (long)string.length()) {
                return null;
            }
            return string.slice((int)(index - 1L), 1);
        }
        int previousIndex = 0;
        int matchCount = 0;
        for (int i = 0; i <= string.length() - delimiter.length(); ++i) {
            if (!string.equals(i, delimiter.length(), delimiter, 0, delimiter.length())) continue;
            if ((long)(++matchCount) == index) {
                return string.slice(previousIndex, i - previousIndex);
            }
            previousIndex = (i += delimiter.length() - 1) + 1;
        }
        if ((long)matchCount == index - 1L) {
            return string.slice(previousIndex, string.length() - previousIndex);
        }
        return null;
    }

    @Description(value="removes spaces from the beginning of a string")
    @ScalarFunction(value="ltrim")
    @SqlType(value=VarcharType.class)
    public static Slice leftTrim(@SqlType(value=VarcharType.class) Slice slice) {
        int start = StringFunctions.firstNonSpace(slice);
        return slice.slice(start, slice.length() - start);
    }

    @Description(value="removes spaces from the end of a string")
    @ScalarFunction(value="rtrim")
    @SqlType(value=VarcharType.class)
    public static Slice rightTrim(@SqlType(value=VarcharType.class) Slice slice) {
        int end = StringFunctions.lastNonSpace(slice);
        return slice.slice(0, end + 1);
    }

    @Description(value="removes spaces from the beginning and end of a string")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice trim(@SqlType(value=VarcharType.class) Slice slice) {
        int start = StringFunctions.firstNonSpace(slice);
        if (start == slice.length()) {
            return Slices.EMPTY_SLICE;
        }
        int end = StringFunctions.lastNonSpace(slice);
        assert (end >= 0 && end >= start);
        return slice.slice(start, end - start + 1);
    }

    private static int firstNonSpace(Slice slice) {
        for (int i = 0; i < slice.length(); ++i) {
            if (slice.getByte(i) == 32) continue;
            return i;
        }
        return slice.length();
    }

    private static int lastNonSpace(Slice slice) {
        for (int i = slice.length() - 1; i >= 0; --i) {
            if (slice.getByte(i) == 32) continue;
            return i;
        }
        return -1;
    }

    @Description(value="converts the alphabets in a string to lower case")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice lower(@SqlType(value=VarcharType.class) Slice slice) {
        Slice upper = Slices.allocate((int)slice.length());
        for (int i = 0; i < slice.length(); ++i) {
            upper.setByte(i, (int)Ascii.toLowerCase((char)((char)slice.getByte(i))));
        }
        return upper;
    }

    @Description(value="converts all the alphabets in the string to upper case")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice upper(@SqlType(value=VarcharType.class) Slice slice) {
        Slice upper = Slices.allocate((int)slice.length());
        for (int i = 0; i < slice.length(); ++i) {
            upper.setByte(i, (int)Ascii.toUpperCase((char)((char)slice.getByte(i))));
        }
        return upper;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice greatest(@SqlType(value=VarcharType.class) Slice value1, @SqlType(value=VarcharType.class) Slice value2) {
        return value1.compareTo(value2) > 0 ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction
    @SqlType(value=VarcharType.class)
    public static Slice least(@SqlType(value=VarcharType.class) Slice value1, @SqlType(value=VarcharType.class) Slice value2) {
        return value1.compareTo(value2) < 0 ? value1 : value2;
    }
}

