/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.type.SqlType;
import com.google.common.primitives.Doubles;
import java.util.concurrent.ThreadLocalRandom;

public final class MathFunctions {
    private MathFunctions() {
    }

    @Description(value="absolute value")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long abs(@SqlType(value=BigintType.class) long num) {
        return Math.abs(num);
    }

    @Description(value="absolute value")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double abs(@SqlType(value=DoubleType.class) double num) {
        return Math.abs(num);
    }

    @Description(value="arc cosine")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double acos(@SqlType(value=DoubleType.class) double num) {
        return Math.acos(num);
    }

    @Description(value="arc sine")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double asin(@SqlType(value=DoubleType.class) double num) {
        return Math.asin(num);
    }

    @Description(value="arc tangent")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double atan(@SqlType(value=DoubleType.class) double num) {
        return Math.atan(num);
    }

    @Description(value="arc tangent of given fraction")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double atan2(@SqlType(value=DoubleType.class) double num1, @SqlType(value=DoubleType.class) double num2) {
        return Math.atan2(num1, num2);
    }

    @Description(value="cube root")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double cbrt(@SqlType(value=DoubleType.class) double num) {
        return Math.cbrt(num);
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    @SqlType(value=BigintType.class)
    public static long ceiling(@SqlType(value=BigintType.class) long num) {
        return num;
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    @SqlType(value=DoubleType.class)
    public static double ceiling(@SqlType(value=DoubleType.class) double num) {
        return Math.ceil(num);
    }

    @Description(value="cosine")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double cos(@SqlType(value=DoubleType.class) double num) {
        return Math.cos(num);
    }

    @Description(value="hyperbolic cosine")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double cosh(@SqlType(value=DoubleType.class) double num) {
        return Math.cosh(num);
    }

    @Description(value="Euler's number")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double e() {
        return Math.E;
    }

    @Description(value="Euler's number raised to the given power")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double exp(@SqlType(value=DoubleType.class) double num) {
        return Math.exp(num);
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long floor(@SqlType(value=BigintType.class) long num) {
        return num;
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double floor(@SqlType(value=DoubleType.class) double num) {
        return Math.floor(num);
    }

    @Description(value="natural logarithm")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double ln(@SqlType(value=DoubleType.class) double num) {
        return Math.log(num);
    }

    @Description(value="logarithm to base 2")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double log2(@SqlType(value=DoubleType.class) double num) {
        return Math.log(num) / Math.log(2.0);
    }

    @Description(value="logarithm to base 10")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double log10(@SqlType(value=DoubleType.class) double num) {
        return Math.log10(num);
    }

    @Description(value="logarithm to given base")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double log(@SqlType(value=DoubleType.class) double num, @SqlType(value=DoubleType.class) double base) {
        return Math.log(num) / Math.log(base);
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long mod(@SqlType(value=BigintType.class) long num1, @SqlType(value=BigintType.class) long num2) {
        return num1 % num2;
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double mod(@SqlType(value=DoubleType.class) double num1, @SqlType(value=DoubleType.class) double num2) {
        return num1 % num2;
    }

    @Description(value="the constant Pi")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double pi() {
        return Math.PI;
    }

    @Description(value="value raised to the power of exponent")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double pow(@SqlType(value=DoubleType.class) double num, @SqlType(value=DoubleType.class) double exponent) {
        return Math.pow(num, exponent);
    }

    @Description(value="a pseudo-random value")
    @ScalarFunction(alias={"rand"}, deterministic=false)
    @SqlType(value=DoubleType.class)
    public static double random() {
        return ThreadLocalRandom.current().nextDouble();
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long round(@SqlType(value=BigintType.class) long num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long round(@SqlType(value=BigintType.class) long num, @SqlType(value=BigintType.class) long decimals) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double round(@SqlType(value=DoubleType.class) double num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to given number of decimal places")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double round(@SqlType(value=DoubleType.class) double num, @SqlType(value=BigintType.class) long decimals) {
        if (num == 0.0) {
            return 0.0;
        }
        if (num < 0.0) {
            return -MathFunctions.round(-num, decimals);
        }
        double factor = Math.pow(10.0, decimals);
        return Math.floor(num * factor + 0.5) / factor;
    }

    @Description(value="sine")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double sin(@SqlType(value=DoubleType.class) double num) {
        return Math.sin(num);
    }

    @Description(value="square root")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double sqrt(@SqlType(value=DoubleType.class) double num) {
        return Math.sqrt(num);
    }

    @Description(value="tangent")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double tan(@SqlType(value=DoubleType.class) double num) {
        return Math.tan(num);
    }

    @Description(value="hyperbolic tangent")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double tanh(@SqlType(value=DoubleType.class) double num) {
        return Math.tanh(num);
    }

    @Description(value="test if value is not-a-number")
    @ScalarFunction(value="is_nan")
    @SqlType(value=BooleanType.class)
    public static boolean isNaN(@SqlType(value=DoubleType.class) double num) {
        return Double.isNaN(num);
    }

    @Description(value="test if value is finite")
    @ScalarFunction
    @SqlType(value=BooleanType.class)
    public static boolean isFinite(@SqlType(value=DoubleType.class) double num) {
        return Doubles.isFinite((double)num);
    }

    @Description(value="test if value is infinite")
    @ScalarFunction
    @SqlType(value=BooleanType.class)
    public static boolean isInfinite(@SqlType(value=DoubleType.class) double num) {
        return Double.isInfinite(num);
    }

    @Description(value="constant representing not-a-number")
    @ScalarFunction(value="nan")
    @SqlType(value=DoubleType.class)
    public static double NaN() {
        return Double.NaN;
    }

    @Description(value="Infinity")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double infinity() {
        return Double.POSITIVE_INFINITY;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long greatest(@SqlType(value=BigintType.class) long value1, @SqlType(value=BigintType.class) long value2) {
        return value1 > value2 ? value1 : value2;
    }

    @Description(value="get the largest of the given values")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double greatest(@SqlType(value=DoubleType.class) double value1, @SqlType(value=DoubleType.class) double value2) {
        if (Double.isNaN(value1) || Double.isNaN(value2)) {
            throw new PrestoException(StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode(), "Invalid argument to greatest(): NaN");
        }
        return value1 > value2 ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction
    @SqlType(value=BigintType.class)
    public static long least(@SqlType(value=BigintType.class) long value1, @SqlType(value=BigintType.class) long value2) {
        return value1 < value2 ? value1 : value2;
    }

    @Description(value="get the smallest of the given values")
    @ScalarFunction
    @SqlType(value=DoubleType.class)
    public static double least(@SqlType(value=DoubleType.class) double value1, @SqlType(value=DoubleType.class) double value2) {
        if (Double.isNaN(value1) || Double.isNaN(value2)) {
            throw new PrestoException(StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode(), "Invalid argument to least(): NaN");
        }
        return value1 < value2 ? value1 : value2;
    }
}

