/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class UpdateRequest {
    private final List<BlockCursor> cursors;
    private final AtomicBoolean finished = new AtomicBoolean();

    public UpdateRequest(BlockCursor ... cursors) {
        this((List<BlockCursor>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)cursors, (Object)"cursors is null"))));
    }

    public UpdateRequest(List<BlockCursor> cursors) {
        this.cursors = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(cursors, (Object)"cursors is null")));
    }

    public BlockCursor[] duplicateCursors() {
        BlockCursor[] duplicates = new BlockCursor[this.cursors.size()];
        for (int i = 0; i < this.cursors.size(); ++i) {
            BlockCursor cursor = this.cursors.get(i);
            duplicates[i] = cursor.duplicate();
        }
        return duplicates;
    }

    public void finished() {
        this.finished.set(true);
    }

    public boolean isFinished() {
        return this.finished.get();
    }
}

