/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PagesIndexBuilderOperator
implements Operator {
    private final List<Type> types;
    private final OperatorContext operatorContext;
    private final PagesIndex pagesIndex;
    private boolean finished;

    public PagesIndexBuilderOperator(List<Type> types, OperatorContext operatorContext, PagesIndex pagesIndex) {
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.pagesIndex = (PagesIndex)Preconditions.checkNotNull((Object)pagesIndex, (Object)"pagesIndex is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.pagesIndex.addPage(page);
        this.operatorContext.recordGeneratedOutput(page.getDataSize(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class PagesIndexBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> types;
        private final AtomicReference<PagesIndex> pagesIndexReference = new AtomicReference();
        private boolean closed;

        public PagesIndexBuilderOperatorFactory(int operatorId, List<Type> types) {
            this.operatorId = operatorId;
            this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        }

        public void setPagesIndex(PagesIndex pagesIndex) {
            Preconditions.checkNotNull((Object)pagesIndex, (Object)"pagesIndex is null");
            Preconditions.checkState((boolean)this.pagesIndexReference.compareAndSet(null, pagesIndex), (Object)"Pages index has already been set");
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            PagesIndex pagesIndex = this.pagesIndexReference.get();
            Preconditions.checkState((pagesIndex != null ? 1 : 0) != 0, (Object)"Pages index has not been set");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, PagesIndexBuilderOperator.class.getSimpleName());
            return new PagesIndexBuilderOperator(this.types, operatorContext, pagesIndex);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

