/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IndexLookupSource
implements LookupSource {
    private final IndexLoader indexLoader;
    private IndexSnapshot indexSnapshot;

    public IndexLookupSource(IndexLoader indexLoader) {
        this.indexLoader = (IndexLoader)Preconditions.checkNotNull((Object)indexLoader, (Object)"indexLoader is null");
        this.indexSnapshot = indexLoader.getIndexSnapshot();
    }

    @Override
    public int getChannelCount() {
        return this.indexLoader.getChannelCount();
    }

    @Override
    public long getJoinPosition(BlockCursor ... cursors) {
        long position = this.indexSnapshot.getJoinPosition(cursors);
        if (position == -2L) {
            this.indexSnapshot = this.indexLoader.getIndexSnapshotForKeys(cursors);
            position = this.indexSnapshot.getJoinPosition(cursors);
            Preconditions.checkState((position != -2L ? 1 : 0) != 0);
        }
        return position;
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        long nextPosition = this.indexSnapshot.getNextJoinPosition(currentPosition);
        Preconditions.checkState((nextPosition != -2L ? 1 : 0) != 0);
        return nextPosition;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        this.indexSnapshot.appendTo(position, pageBuilder, outputChannelOffset);
    }
}

