/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.IndexSplit;
import com.facebook.presto.operator.index.PagesIndexBuilderOperator;
import com.facebook.presto.operator.index.UnloadedIndexKeyRecordSet;
import com.facebook.presto.operator.index.UpdateRequest;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class IndexLoader {
    private final BlockingQueue<UpdateRequest> updateRequests = new LinkedBlockingQueue<UpdateRequest>();
    private final List<Type> indexTypes;
    private final List<Type> outputTypes;
    private final int snapshotOperatorId;
    private final DriverFactory driverFactory;
    private final PlanNodeId sourcePlanNodeId;
    private final PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory pagesIndexOutput;
    private final int expectedPositions;
    private final AtomicReference<TaskContext> taskContextReference = new AtomicReference();
    private final List<Integer> indexChannels;
    @GuardedBy(value="this")
    private IndexSnapshotBuilder indexSnapshotBuilder;
    private volatile IndexSnapshot indexSnapshot;

    public IndexLoader(List<Integer> indexChannels, List<Type> types, int snapshotOperatorId, DriverFactory driverFactory, PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory pagesIndexOutput, int expectedPositions) {
        Preconditions.checkArgument((!indexChannels.isEmpty() ? 1 : 0) != 0, (Object)"indexChannels must not be empty");
        this.indexChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(indexChannels, (Object)"indexChannels is null")));
        this.outputTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.snapshotOperatorId = snapshotOperatorId;
        this.driverFactory = (DriverFactory)Preconditions.checkNotNull((Object)driverFactory, (Object)"driverFactory is null");
        this.sourcePlanNodeId = (PlanNodeId)Iterables.getOnlyElement(driverFactory.getSourceIds());
        this.pagesIndexOutput = (PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory)Preconditions.checkNotNull((Object)pagesIndexOutput, (Object)"pagesIndexOutput is null");
        this.expectedPositions = (Integer)Preconditions.checkNotNull((Object)expectedPositions, (Object)"expectedPositions is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (Integer outputIndexChannel : indexChannels) {
            typeBuilder.add((Object)types.get(outputIndexChannel));
        }
        this.indexTypes = typeBuilder.build();
        this.indexSnapshot = new IndexSnapshot(new EmptyLookupSource(types.size()), new EmptyLookupSource(indexChannels.size()));
    }

    public void setContext(TaskContext taskContext) {
        this.taskContextReference.compareAndSet(null, taskContext);
    }

    public int getChannelCount() {
        return this.outputTypes.size();
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public IndexSnapshot getIndexSnapshot() {
        return this.indexSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSnapshot getIndexSnapshotForKeys(BlockCursor[] indexCursors) {
        UpdateRequest updateRequest = new UpdateRequest(indexCursors);
        this.updateRequests.add(updateRequest);
        IndexLoader indexLoader = this;
        synchronized (indexLoader) {
            if (!updateRequest.isFinished()) {
                ArrayList<UpdateRequest> requests = new ArrayList<UpdateRequest>();
                this.updateRequests.drainTo(requests);
                this.batchLoadRequests(requests);
                for (UpdateRequest request : requests) {
                    request.finished();
                }
            }
        }
        return this.indexSnapshot;
    }

    private synchronized void batchLoadRequests(List<UpdateRequest> requests) {
        if (this.indexSnapshotBuilder == null) {
            TaskContext taskContext = this.taskContextReference.get();
            Preconditions.checkState((taskContext != null ? 1 : 0) != 0, (Object)"Task context must be set before index can be built");
            PipelineContext pipelineContext = taskContext.addPipelineContext(false, false);
            this.indexSnapshotBuilder = new IndexSnapshotBuilder(this.driverFactory, pipelineContext, this.sourcePlanNodeId, this.pagesIndexOutput, this.indexChannels, this.snapshotOperatorId, this.expectedPositions);
        }
        this.indexSnapshot = this.indexSnapshotBuilder.batchLoadRequests(new UnloadedIndexKeyRecordSet(this.indexSnapshot, this.indexTypes, requests));
    }

    private static class EmptyLookupSource
    implements LookupSource {
        private final int channelCount;

        private EmptyLookupSource(int channelCount) {
            this.channelCount = channelCount;
        }

        @Override
        public int getChannelCount() {
            return this.channelCount;
        }

        @Override
        public long getJoinPosition(BlockCursor ... cursors) {
            return -2L;
        }

        @Override
        public long getNextJoinPosition(long currentPosition) {
            return -2L;
        }

        @Override
        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    private static class IndexSnapshotBuilder {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final PlanNodeId sourcePlanNodeId;
        private final List<Integer> indexChannels;
        private final PagesIndex pagesIndex;
        private final PagesIndex missingKeysIndex;
        private final List<Integer> missingKeysChannels;
        private LookupSource missingKeys;

        private IndexSnapshotBuilder(DriverFactory driverFactory, PipelineContext pipelineContext, PlanNodeId sourcePlanNodeId, PagesIndexBuilderOperator.PagesIndexBuilderOperatorFactory pagesIndexOutput, List<Integer> indexChannels, int snapshotOperatorId, int expectedPositions) {
            this.driverFactory = driverFactory;
            this.pipelineContext = pipelineContext;
            this.sourcePlanNodeId = sourcePlanNodeId;
            this.indexChannels = indexChannels;
            OperatorContext snapshotOperatorContext = pipelineContext.addDriverContext().addOperatorContext(snapshotOperatorId, IndexLoader.class.getSimpleName());
            this.pagesIndex = new PagesIndex(pagesIndexOutput.getTypes(), expectedPositions, snapshotOperatorContext);
            pagesIndexOutput.setPagesIndex(this.pagesIndex);
            ImmutableList.Builder missingKeysTypes = ImmutableList.builder();
            ImmutableList.Builder missingKeysChannels = ImmutableList.builder();
            for (int i = 0; i < indexChannels.size(); ++i) {
                Integer outputIndexChannel = indexChannels.get(i);
                missingKeysTypes.add((Object)pagesIndexOutput.getTypes().get(outputIndexChannel));
                missingKeysChannels.add((Object)i);
            }
            this.missingKeysIndex = new PagesIndex((List<Type>)missingKeysTypes.build(), expectedPositions, snapshotOperatorContext);
            this.missingKeysChannels = missingKeysChannels.build();
            this.missingKeys = new EmptyLookupSource(indexChannels.size());
        }

        private IndexSnapshot batchLoadRequests(UnloadedIndexKeyRecordSet unloadedKeysRecordSet) {
            Driver driver = this.driverFactory.createDriver(this.pipelineContext.addDriverContext());
            driver.updateSource(new TaskSource(this.sourcePlanNodeId, (Set<ScheduledSplit>)ImmutableSet.of((Object)new ScheduledSplit(0L, new Split("index", new IndexSplit(unloadedKeysRecordSet)))), true));
            while (!driver.isFinished()) {
                ListenableFuture<?> process = driver.process();
                Preconditions.checkState((boolean)process.isDone(), (Object)"Driver should never block");
            }
            LookupSource lookupSource = this.pagesIndex.createLookupSource(this.indexChannels);
            PageBuilder missingKeysPageBuilder = new PageBuilder(this.missingKeysIndex.getTypes());
            UnloadedIndexKeyRecordSet.UnloadedIndexKeyRecordCursor unloadedKeyRecordCursor = unloadedKeysRecordSet.cursor();
            while (unloadedKeyRecordCursor.advanceNextPosition()) {
                BlockCursor[] cursors = unloadedKeyRecordCursor.asBlockCursors();
                if (lookupSource.getJoinPosition(cursors) >= 0L) continue;
                for (int i = 0; i < cursors.length; ++i) {
                    cursors[i].appendTo(missingKeysPageBuilder.getBlockBuilder(i));
                }
            }
            if (!missingKeysPageBuilder.isEmpty()) {
                this.missingKeysIndex.addPage(missingKeysPageBuilder.build());
                this.missingKeys = this.missingKeysIndex.createLookupSource(this.missingKeysChannels);
            }
            return new IndexSnapshot(lookupSource, this.missingKeys);
        }
    }
}

