/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.OnlineVarianceCalculator;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;

public class VarianceAggregation
extends AbstractAggregationFunction<VarianceState> {
    protected final boolean population;
    protected final boolean inputIsLong;
    protected final boolean standardDeviation;

    public VarianceAggregation(Type parameterType, boolean population, boolean standardDeviation) {
        super((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, parameterType);
        this.population = population;
        if (parameterType == BigintType.BIGINT) {
            this.inputIsLong = true;
        } else if (parameterType == DoubleType.DOUBLE) {
            this.inputIsLong = false;
        } else {
            throw new IllegalArgumentException("Expected parameter type to be BIGINT or DOUBLE, but was " + parameterType);
        }
        this.standardDeviation = standardDeviation;
    }

    @Override
    protected void processInput(VarianceState state, BlockCursor cursor) {
        double inputValue = this.inputIsLong ? (double)cursor.getLong() : cursor.getDouble();
        OnlineVarianceCalculator.updateState(state, inputValue);
    }

    @Override
    protected void evaluateFinal(VarianceState state, BlockBuilder out) {
        long count = state.getCount();
        if (this.population) {
            if (count == 0L) {
                out.appendNull();
            } else {
                double m2 = state.getM2();
                double result = m2 / (double)count;
                if (this.standardDeviation) {
                    result = Math.sqrt(result);
                }
                out.appendDouble(result);
            }
        } else if (count < 2L) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double result = m2 / (double)(count - 1L);
            if (this.standardDeviation) {
                result = Math.sqrt(result);
            }
            out.appendDouble(result);
        }
    }

    @Override
    protected void evaluateIntermediate(VarianceState state, BlockBuilder out) {
        out.appendSlice(OnlineVarianceCalculator.toSlice(state));
    }

    @Override
    protected void processIntermediate(VarianceState state, BlockCursor cursor) {
        Slice slice = cursor.getSlice();
        OnlineVarianceCalculator.mergeState(state, slice);
    }
}

