/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.state.SliceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;

public class VarBinaryMinAggregation
extends AbstractAggregationFunction<SliceState> {
    public static final VarBinaryMinAggregation VAR_BINARY_MIN = new VarBinaryMinAggregation();

    public VarBinaryMinAggregation() {
        super((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
    }

    @Override
    protected void processInput(SliceState state, BlockCursor cursor) {
        state.setSlice(VarBinaryMinAggregation.min(state.getSlice(), cursor.getSlice()));
    }

    @Override
    protected void evaluateFinal(SliceState state, BlockBuilder out) {
        if (state.getSlice() != null) {
            out.appendSlice(state.getSlice());
        } else {
            out.appendNull();
        }
    }

    private static Slice min(Slice a, Slice b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) < 0 ? a : b;
    }
}

