/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class OnlineVarianceCalculator {
    private static final int COUNT_OFFSET = 0;
    private static final int MEAN_OFFSET = 8;
    private static final int M2_OFFSET = 16;
    private long count;
    private double m2;
    private double mean;

    public void add(double value) {
        ++this.count;
        double delta = value - this.mean;
        this.mean += delta / (double)this.count;
        this.m2 += delta * (value - this.mean);
    }

    public void merge(OnlineVarianceCalculator other) {
        this.merge(other.getCount(), other.getMean(), other.getM2());
    }

    public void merge(long count, double mean, double m2) {
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        if (count == 0L) {
            return;
        }
        long newCount = count + this.count;
        double newMean = ((double)count * mean + (double)this.count * this.mean) / (double)newCount;
        double delta = mean - this.mean;
        this.m2 += m2 + delta * delta * (double)count * (double)this.count / (double)newCount;
        this.count = newCount;
        this.mean = newMean;
    }

    public static int sizeOf() {
        return 24;
    }

    public long getCount() {
        return this.count;
    }

    public double getM2() {
        return this.m2;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSampleVariance() {
        return this.m2 / (double)(this.count - 1L);
    }

    public double getPopulationVariance() {
        return this.m2 / (double)this.count;
    }

    public void reinitialize(long count, double mean, double m2) {
        this.count = count;
        this.mean = mean;
        this.m2 = m2;
    }

    public void serializeTo(Slice slice, int offset) {
        slice.setLong(offset + 0, this.count);
        slice.setDouble(offset + 8, this.mean);
        slice.setDouble(offset + 16, this.m2);
    }

    public static void updateState(VarianceState state, double value) {
        state.setCount(state.getCount() + 1L);
        double delta = value - state.getMean();
        state.setMean(state.getMean() + delta / (double)state.getCount());
        state.setM2(state.getM2() + delta * (value - state.getMean()));
    }

    public static Slice toSlice(VarianceState state) {
        Slice slice = Slices.allocate((int)OnlineVarianceCalculator.sizeOf());
        slice.setLong(0, state.getCount());
        slice.setDouble(8, state.getMean());
        slice.setDouble(16, state.getM2());
        return slice;
    }

    public static void mergeState(VarianceState state, Slice slice) {
        long count = slice.getLong(0);
        double mean = slice.getDouble(8);
        double m2 = slice.getDouble(16);
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        if (count == 0L) {
            return;
        }
        long newCount = count + state.getCount();
        double newMean = ((double)count * mean + (double)state.getCount() * state.getMean()) / (double)newCount;
        double delta = mean - state.getMean();
        double m2Delta = m2 + delta * delta * (double)count * (double)state.getCount() / (double)newCount;
        state.setM2(state.getM2() + m2Delta);
        state.setCount(newCount);
        state.setMean(newMean);
    }

    public void deserializeFrom(Slice slice, int offset) {
        this.count = slice.getLong(offset + 0);
        this.mean = slice.getDouble(offset + 8);
        this.m2 = slice.getDouble(offset + 16);
    }
}

