/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.ObjectBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;

public class MergeHyperLogLogAggregation
extends SimpleAggregationFunction {
    public MergeHyperLogLogAggregation() {
        super((Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG);
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"confidence level must be 1.0");
        return new MergeHyperLogLogGroupedAccumulator(valueChannel, maskChannel, sampleWeightChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"confidence level must be 1.0");
        return new MergeHyperLogLogAccumulator(valueChannel, maskChannel);
    }

    static class MergeHyperLogLogGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final ObjectBigArray<HyperLogLog> estimators = new ObjectBigArray();
        private long sizeOfValues;

        public MergeHyperLogLogGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            super(valueChannel, (Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG, maskChannel, sampleWeightChannel);
        }

        @Override
        public long getEstimatedSize() {
            return this.sizeOfValues;
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.estimators.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (values.isNull() || masks != null && !masks.getBoolean()) continue;
                this.add(groupIdsBlock.getGroupId(position), values);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0, (Object)"group id and value blocks have different number of entries");
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            HyperLogLog estimator = this.estimators.get(groupId);
            if (estimator == null) {
                output.appendNull();
            } else {
                output.appendSlice(estimator.serialize());
            }
        }

        private void add(long groupId, BlockCursor cursor) {
            HyperLogLog instance = HyperLogLog.newInstance((Slice)cursor.getSlice());
            HyperLogLog previous = this.estimators.get(groupId);
            if (previous == null) {
                this.estimators.set(groupId, instance);
                this.sizeOfValues += (long)instance.estimatedInMemorySize();
            } else {
                this.sizeOfValues -= (long)previous.estimatedInMemorySize();
                previous.mergeWith(instance);
                this.sizeOfValues += (long)previous.estimatedInMemorySize();
            }
        }
    }

    static class MergeHyperLogLogAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private HyperLogLog estimator;

        public MergeHyperLogLogAccumulator(int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, (Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG, maskChannel, (Optional<Integer>)Optional.absent());
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (values.isNull() || masks != null && !masks.getBoolean()) continue;
                this.add(values);
            }
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.estimator == null) {
                out.appendNull();
            } else {
                out.appendSlice(this.estimator.serialize());
            }
        }

        private void add(BlockCursor cursor) {
            HyperLogLog instance = HyperLogLog.newInstance((Slice)cursor.getSlice());
            if (this.estimator == null) {
                this.estimator = instance;
            } else {
                this.estimator.mergeWith(instance);
            }
        }
    }
}

