/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

public class LongSumAggregation
extends AbstractAggregationFunction<NullableLongState> {
    public static final AggregationFunction LONG_SUM = new LongSumAggregation();

    public LongSumAggregation() {
        super((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
    }

    @Override
    public void processInput(NullableLongState state, BlockCursor cursor) {
        state.setNull(false);
        state.setLong(state.getLong() + cursor.getLong());
    }

    @Override
    public void evaluateFinal(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            out.appendLong(state.getLong());
        }
    }
}

