/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

public class LongMinAggregation
extends AbstractAggregationFunction<LongMinState> {
    public static final LongMinAggregation LONG_MIN = new LongMinAggregation();

    public LongMinAggregation() {
        super((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
    }

    @Override
    public void processInput(LongMinState state, BlockCursor cursor) {
        state.setNotNull(true);
        state.setLong(Math.min(state.getLong(), cursor.getLong()));
    }

    @Override
    public void evaluateFinal(LongMinState state, BlockBuilder out) {
        if (state.getNotNull()) {
            out.appendLong(state.getLong());
        } else {
            out.appendNull();
        }
    }

    public static interface LongMinState
    extends AccumulatorState {
        @InitialLongValue(value=0x7FFFFFFFFFFFFFFFL)
        public long getLong();

        public void setLong(long var1);

        public boolean getNotNull();

        public void setNotNull(boolean var1);
    }
}

