/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

public class LongMaxAggregation
extends AbstractAggregationFunction<LongMaxState> {
    public static final LongMaxAggregation LONG_MAX = new LongMaxAggregation();

    public LongMaxAggregation() {
        super((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
    }

    @Override
    public void processInput(LongMaxState state, BlockCursor cursor) {
        state.setNotNull(true);
        state.setLong(Math.max(state.getLong(), cursor.getLong()));
    }

    @Override
    public void evaluateFinal(LongMaxState state, BlockBuilder out) {
        if (state.getNotNull()) {
            out.appendLong(state.getLong());
        } else {
            out.appendNull();
        }
    }

    public static interface LongMaxState
    extends AccumulatorState {
        @InitialLongValue(value=-9223372036854775808L)
        public long getLong();

        public void setLong(long var1);

        public boolean getNotNull();

        public void setNotNull(boolean var1);
    }
}

