/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateSetAggregation;
import com.facebook.presto.operator.aggregation.IsolatedClass;
import com.facebook.presto.operator.aggregation.MergeHyperLogLogAggregation;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Throwables;

public final class HyperLogLogAggregations {
    public static final AggregationFunction BIGINT_APPROXIMATE_SET_AGGREGATION = HyperLogLogAggregations.createIsolatedAggregation((Type)BigintType.BIGINT);
    public static final AggregationFunction VARCHAR_APPROXIMATE_SET_AGGREGATION = HyperLogLogAggregations.createIsolatedAggregation((Type)VarcharType.VARCHAR);
    public static final AggregationFunction DOUBLE_APPROXIMATE_SET_AGGREGATION = HyperLogLogAggregations.createIsolatedAggregation((Type)DoubleType.DOUBLE);
    public static final AggregationFunction MERGE_HYPER_LOG_LOG_AGGREGATION = new MergeHyperLogLogAggregation();

    private HyperLogLogAggregations() {
    }

    private static AggregationFunction createIsolatedAggregation(Type parameterType) {
        Class<ApproximateSetAggregation> functionClass = IsolatedClass.isolateClass(AggregationFunction.class, ApproximateSetAggregation.class, SimpleAggregationFunction.class, ApproximateSetAggregation.ApproximateSetGroupedAccumulator.class, SimpleAggregationFunction.SimpleGroupedAccumulator.class, ApproximateSetAggregation.ApproximateSetAccumulator.class, SimpleAggregationFunction.SimpleAccumulator.class);
        try {
            return functionClass.getConstructor(Type.class).newInstance(parameterType);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

