/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;

public class DoubleSumAggregation
extends AbstractAggregationFunction<NullableDoubleState> {
    public static final AggregationFunction DOUBLE_SUM = new DoubleSumAggregation();

    public DoubleSumAggregation() {
        super((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
    }

    @Override
    public void processInput(NullableDoubleState state, BlockCursor cursor) {
        state.setNull(false);
        state.setDouble(state.getDouble() + cursor.getDouble());
    }

    @Override
    public void evaluateFinal(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            out.appendDouble(state.getDouble());
        }
    }
}

