/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.InitialDoubleValue;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;

public class DoubleMinAggregation
extends AbstractAggregationFunction<DoubleMinState> {
    public static final DoubleMinAggregation DOUBLE_MIN = new DoubleMinAggregation();

    public DoubleMinAggregation() {
        super((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
    }

    @Override
    public void processInput(DoubleMinState state, BlockCursor cursor) {
        state.setNotNull(true);
        state.setDouble(Math.min(state.getDouble(), cursor.getDouble()));
    }

    @Override
    public void evaluateFinal(DoubleMinState state, BlockBuilder out) {
        if (state.getNotNull()) {
            out.appendDouble(state.getDouble());
        } else {
            out.appendNull();
        }
    }

    public static interface DoubleMinState
    extends AccumulatorState {
        @InitialDoubleValue(value=Infinity)
        public double getDouble();

        public void setDouble(double var1);

        public boolean getNotNull();

        public void setNotNull(boolean var1);
    }
}

