/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.state.ByteState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;

public class BooleanMaxAggregation
extends AbstractAggregationFunction<ByteState> {
    public static final BooleanMaxAggregation BOOLEAN_MAX = new BooleanMaxAggregation();
    private static final byte NULL_VALUE = 0;
    private static final byte TRUE_VALUE = 1;
    private static final byte FALSE_VALUE = -1;

    public BooleanMaxAggregation() {
        super((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN);
    }

    @Override
    protected void processInput(ByteState state, BlockCursor cursor) {
        if (cursor.getBoolean()) {
            state.setByte((byte)1);
        } else if (state.getByte() == 0) {
            state.setByte((byte)-1);
        }
    }

    @Override
    protected void evaluateFinal(ByteState state, BlockBuilder out) {
        if (state.getByte() == 0) {
            out.appendNull();
        } else {
            out.appendBoolean(state.getByte() == 1);
        }
    }
}

