/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.state.LongAndDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class AverageAggregation
extends AbstractAggregationFunction<LongAndDoubleState> {
    private final boolean inputIsLong;

    public AverageAggregation(Type parameterType) {
        super((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, parameterType);
        if (parameterType == BigintType.BIGINT) {
            this.inputIsLong = true;
        } else if (parameterType == DoubleType.DOUBLE) {
            this.inputIsLong = false;
        } else {
            throw new IllegalArgumentException("Expected parameter type to be BIGINT or DOUBLE, but was " + parameterType);
        }
    }

    @Override
    protected void processInput(LongAndDoubleState state, BlockCursor cursor) {
        state.setLong(state.getLong() + 1L);
        double value = this.inputIsLong ? (double)cursor.getLong() : cursor.getDouble();
        state.setDouble(state.getDouble() + value);
    }

    @Override
    public void evaluateIntermediate(LongAndDoubleState state, BlockBuilder output) {
        long count = state.getLong();
        double sum = state.getDouble();
        Slice value = Slices.allocate((int)16);
        value.setLong(0, count);
        value.setDouble(8, sum);
        output.appendSlice(value);
    }

    @Override
    public void processIntermediate(LongAndDoubleState state, BlockCursor cursor) {
        Slice value = cursor.getSlice();
        long count = value.getLong(0);
        state.setLong(state.getLong() + count);
        double sum = value.getDouble(8);
        state.setDouble(state.getDouble() + sum);
    }

    @Override
    protected void evaluateFinal(LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            out.appendDouble(value / (double)count);
        }
    }
}

