/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.array.ObjectBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;

public class ApproximateSetAggregation
extends SimpleAggregationFunction {
    private static final int NUMBER_OF_BUCKETS = 4096;
    private final Type parameterType;

    public ApproximateSetAggregation(Type parameterType) {
        super((Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG, parameterType);
        Preconditions.checkArgument((parameterType.equals(BigintType.BIGINT) || parameterType.equals(DoubleType.DOUBLE) || parameterType.equals(VarcharType.VARCHAR) ? 1 : 0) != 0, (String)"Expected parameter type to be BIGINT, DOUBLE, or VARCHAR, but was %s", (Object[])new Object[]{parameterType});
        this.parameterType = parameterType;
    }

    @Override
    protected GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"confidence level must be 1.0");
        return new ApproximateSetGroupedAccumulator(this.parameterType, valueChannel, maskChannel, sampleWeightChannel);
    }

    @Override
    protected Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"confidence level must be 1.0");
        return new ApproximateSetAccumulator(this.parameterType, valueChannel, maskChannel);
    }

    private static void add(BlockCursor cursor, Type parameterType, HyperLogLog estimator) {
        if (parameterType.equals(BigintType.BIGINT)) {
            estimator.add(cursor.getLong());
        } else if (parameterType.equals(DoubleType.DOUBLE)) {
            estimator.add(Double.doubleToLongBits(cursor.getDouble()));
        } else if (parameterType.equals(VarcharType.VARCHAR)) {
            estimator.add(cursor.getSlice());
        } else {
            throw new IllegalArgumentException("Expected parameter type to be BIGINT, DOUBLE, or VARCHAR");
        }
    }

    static class ApproximateSetGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final ObjectBigArray<HyperLogLog> estimators = new ObjectBigArray();
        private final Type parameterType;
        private long sizeOfValues;

        public ApproximateSetGroupedAccumulator(Type parameterType, int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            super(valueChannel, (Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG, maskChannel, sampleWeightChannel);
            this.parameterType = parameterType;
        }

        @Override
        public long getEstimatedSize() {
            return this.sizeOfValues;
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.estimators.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (values.isNull() || masks != null && !masks.getBoolean()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                HyperLogLog hll = this.estimators.get(groupId);
                if (hll == null) {
                    hll = HyperLogLog.newInstance((int)4096);
                    this.estimators.set(groupId, hll);
                    this.sizeOfValues += (long)hll.estimatedInMemorySize();
                }
                this.sizeOfValues -= (long)hll.estimatedInMemorySize();
                ApproximateSetAggregation.add(values, this.parameterType, hll);
                this.sizeOfValues += (long)hll.estimatedInMemorySize();
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0, (Object)"group id and value blocks have different number of entries");
        }

        @Override
        protected void processIntermediate(GroupByIdBlock groupIdsBlock, Block valuesBlock) {
            this.estimators.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = valuesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                long groupId = groupIdsBlock.getGroupId(position);
                HyperLogLog input = HyperLogLog.newInstance((Slice)intermediates.getSlice());
                HyperLogLog previous = this.estimators.get(groupId);
                if (previous == null) {
                    this.estimators.set(groupId, input);
                    this.sizeOfValues += (long)input.estimatedInMemorySize();
                    continue;
                }
                this.sizeOfValues -= (long)previous.estimatedInMemorySize();
                previous.mergeWith(input);
                this.sizeOfValues += (long)previous.estimatedInMemorySize();
            }
            Preconditions.checkState((!intermediates.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.evaluateFinal(groupId, output);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            HyperLogLog estimator = this.estimators.get(groupId);
            if (estimator == null) {
                output.appendNull();
            } else {
                output.appendSlice(estimator.serialize());
            }
        }
    }

    static class ApproximateSetAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private final Type parameterType;
        private HyperLogLog estimator;

        public ApproximateSetAccumulator(Type parameterType, int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, (Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG, maskChannel, (Optional<Integer>)Optional.absent());
            this.parameterType = parameterType;
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (values.isNull() || masks != null && !masks.getBoolean()) continue;
                if (this.estimator == null) {
                    this.estimator = HyperLogLog.newInstance((int)4096);
                }
                ApproximateSetAggregation.add(values, this.parameterType, this.estimator);
            }
        }

        @Override
        protected void processIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                HyperLogLog instance = HyperLogLog.newInstance((Slice)intermediates.getSlice());
                if (this.estimator == null) {
                    this.estimator = instance;
                    continue;
                }
                this.estimator.mergeWith(instance);
            }
        }

        @Override
        public void evaluateIntermediate(BlockBuilder out) {
            this.evaluateFinal(out);
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.estimator == null) {
                out.appendNull();
            } else {
                out.appendSlice(this.estimator.serialize());
            }
        }
    }
}

