/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.OnlineVarianceCalculator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.array.DoubleBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class ApproximateDoubleSumAggregation
extends SimpleAggregationFunction {
    public static final ApproximateDoubleSumAggregation DOUBLE_APPROXIMATE_SUM_AGGREGATION = new ApproximateDoubleSumAggregation();
    private static final int COUNT_OFFSET = 0;
    private static final int SUM_OFFSET = 8;
    private static final int VARIANCE_OFFSET = 16;

    public ApproximateDoubleSumAggregation() {
        super((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE);
    }

    @Override
    public ApproximateSumGroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((boolean)(sampleWeightChannel.isPresent() ^ valueChannel == -1), (Object)"sampleWeightChannel is missing");
        return new ApproximateSumGroupedAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    @Override
    public ApproximateSumAccumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((boolean)(sampleWeightChannel.isPresent() ^ valueChannel == -1), (Object)"sampleWeightChannel is missing");
        return new ApproximateSumAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    public static Slice createIntermediate(long count, double sum, OnlineVarianceCalculator calculator) {
        Slice slice = Slices.allocate((int)(16 + calculator.sizeOf()));
        slice.setLong(0, count);
        slice.setDouble(8, sum);
        calculator.serializeTo(slice, 16);
        return slice;
    }

    public static class ApproximateSumAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private double sum;
        private long count;
        private final OnlineVarianceCalculator calculator = new OnlineVarianceCalculator();
        private final double confidence;

        public ApproximateSumAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, (Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, maskChannel, sampleWeightChannel);
            this.confidence = confidence;
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int i = 0; i < block.getPositionCount(); ++i) {
                long weight;
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                Preconditions.checkState((boolean)values.advanceNextPosition(), (Object)"failed to advance values cursor");
                long l = weight = values.isNull() ? 0L : SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || weight <= 0L) continue;
                double value = values.getDouble();
                this.count += weight;
                this.sum += value * (double)weight;
                this.calculator.add(value);
            }
        }

        @Override
        public void processIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            OnlineVarianceCalculator calculator = new OnlineVarianceCalculator();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                Slice slice = intermediates.getSlice();
                this.sum += slice.getDouble(8);
                this.count += slice.getLong(0);
                calculator.deserializeFrom(slice, 16);
                this.calculator.merge(calculator);
            }
        }

        @Override
        public void evaluateIntermediate(BlockBuilder out) {
            out.appendSlice(ApproximateDoubleSumAggregation.createIntermediate(this.count, this.sum, this.calculator));
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            if (this.count == 0L) {
                out.appendNull();
                return;
            }
            String result = ApproximateUtils.formatApproximateResult(this.sum, ApproximateUtils.sumError(this.calculator.getCount(), this.count, this.calculator.getM2(), this.calculator.getMean()), this.confidence, false);
            out.appendSlice(Slices.utf8Slice((String)result));
        }
    }

    public static class ApproximateSumGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final LongBigArray counts = new LongBigArray();
        private final LongBigArray samples = new LongBigArray();
        private final DoubleBigArray sums = new DoubleBigArray();
        private final DoubleBigArray m2s = new DoubleBigArray();
        private final DoubleBigArray means = new DoubleBigArray();
        private final double confidence;

        public ApproximateSumGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, (Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, maskChannel, sampleWeightChannel);
            this.confidence = confidence;
        }

        @Override
        public long getEstimatedSize() {
            return this.counts.sizeOf() + this.samples.sizeOf() + this.sums.sizeOf() + this.m2s.sizeOf() + this.means.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            this.sums.ensureCapacity(groupIdsBlock.getGroupCount());
            this.m2s.ensureCapacity(groupIdsBlock.getGroupCount());
            this.means.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            OnlineVarianceCalculator calculator = new OnlineVarianceCalculator();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                long weight;
                long groupId = groupIdsBlock.getGroupId(position);
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                Preconditions.checkState((boolean)values.advanceNextPosition(), (Object)"failed to advance values cursor");
                long l = weight = values.isNull() ? 0L : SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                if (values.isNull() || weight <= 0L) continue;
                double value = values.getDouble();
                this.counts.add(groupId, weight);
                this.sums.add(groupId, value * (double)weight);
                calculator.reinitialize(this.samples.get(groupId), this.means.get(groupId), this.m2s.get(groupId));
                calculator.add(value);
                this.samples.set(groupId, calculator.getCount());
                this.means.set(groupId, calculator.getMean());
                this.m2s.set(groupId, calculator.getM2());
            }
        }

        @Override
        public void processIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            this.sums.ensureCapacity(groupIdsBlock.getGroupCount());
            this.m2s.ensureCapacity(groupIdsBlock.getGroupCount());
            this.means.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = block.cursor();
            OnlineVarianceCalculator calculator = new OnlineVarianceCalculator();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                long groupId = groupIdsBlock.getGroupId(position);
                Slice slice = intermediates.getSlice();
                this.sums.add(groupId, slice.getDouble(8));
                this.counts.add(groupId, slice.getLong(0));
                calculator.deserializeFrom(slice, 16);
                calculator.merge(this.samples.get(groupId), this.means.get(groupId), this.m2s.get(groupId));
                this.samples.set(groupId, calculator.getCount());
                this.means.set(groupId, calculator.getMean());
                this.m2s.set(groupId, calculator.getM2());
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            OnlineVarianceCalculator calculator = new OnlineVarianceCalculator();
            calculator.merge(this.samples.get(groupId), this.means.get(groupId), this.m2s.get(groupId));
            output.appendSlice(ApproximateDoubleSumAggregation.createIntermediate(this.counts.get(groupId), this.sums.get(groupId), calculator));
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            long count = this.counts.get(groupId);
            if (count == 0L) {
                output.appendNull();
                return;
            }
            String result = ApproximateUtils.formatApproximateResult(this.sums.get(groupId), ApproximateUtils.sumError(this.samples.get(groupId), count, this.m2s.get(groupId), this.means.get(groupId)), this.confidence, false);
            output.appendSlice(Slices.utf8Slice((String)result));
        }
    }
}

