/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class ApproximateCountColumnAggregation
extends SimpleAggregationFunction {
    private static final int COUNT_OFFSET = 0;
    private static final int SAMPLES_OFFSET = 8;

    public ApproximateCountColumnAggregation(Type parameterType) {
        super((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, parameterType);
    }

    @Override
    public ApproximateCountColumnGroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((boolean)(sampleWeightChannel.isPresent() ^ valueChannel == -1), (Object)"sampleWeightChannel is missing");
        return new ApproximateCountColumnGroupedAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    @Override
    public ApproximateCountColumnAccumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((boolean)(sampleWeightChannel.isPresent() ^ valueChannel == -1), (Object)"sampleWeightChannel is missing");
        return new ApproximateCountColumnAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    public static Slice createIntermediate(long count, long samples) {
        Slice slice = Slices.allocate((int)16);
        slice.setLong(0, count);
        slice.setLong(8, samples);
        return slice;
    }

    public static class ApproximateCountColumnAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private long count;
        private long samples;
        private final double confidence;

        public ApproximateCountColumnAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, (Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, maskChannel, sampleWeightChannel);
            this.confidence = confidence;
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            BlockCursor values = block.cursor();
            BlockCursor sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int i = 0; i < block.getPositionCount(); ++i) {
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                Preconditions.checkState((boolean)values.advanceNextPosition(), (Object)"failed to advance values cursor");
                long weight = values.isNull() ? 0L : SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                this.count += weight;
                if (weight <= 0L) continue;
                ++this.samples;
            }
        }

        @Override
        public void processIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                Slice slice = intermediates.getSlice();
                this.count += slice.getLong(0);
                this.samples += slice.getLong(8);
            }
        }

        @Override
        public void evaluateIntermediate(BlockBuilder out) {
            out.appendSlice(ApproximateCountColumnAggregation.createIntermediate(this.count, this.samples));
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            String result = ApproximateUtils.formatApproximateResult(this.count, ApproximateUtils.countError(this.samples, this.count), this.confidence, true);
            out.appendSlice(Slices.utf8Slice((String)result));
        }
    }

    public static class ApproximateCountColumnGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final LongBigArray counts = new LongBigArray();
        private final LongBigArray samples = new LongBigArray();
        private final double confidence;

        public ApproximateCountColumnGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, (Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, maskChannel, sampleWeightChannel);
            this.confidence = confidence;
        }

        @Override
        public long getEstimatedSize() {
            return this.counts.sizeOf() + this.samples.sizeOf();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor sampleWeights = ((Block)sampleWeightBlock.get()).cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                long groupId = groupIdsBlock.getGroupId(position);
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0, (Object)"failed to advance mask cursor");
                Preconditions.checkState((boolean)sampleWeights.advanceNextPosition(), (Object)"failed to advance weight cursor");
                Preconditions.checkState((boolean)values.advanceNextPosition(), (Object)"failed to advance values cursor");
                long weight = values.isNull() ? 0L : SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                this.counts.add(groupId, weight);
                if (weight <= 0L) continue;
                this.samples.increment(groupId);
            }
        }

        @Override
        public void processIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            this.samples.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition(), (Object)"failed to advance intermediates cursor");
                long groupId = groupIdsBlock.getGroupId(position);
                Slice slice = intermediates.getSlice();
                this.counts.add(groupId, slice.getLong(0));
                this.samples.add(groupId, slice.getLong(8));
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            output.appendSlice(ApproximateCountColumnAggregation.createIntermediate(this.counts.get(groupId), this.samples.get(groupId)));
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            long count = this.counts.get(groupId);
            long samples = this.samples.get(groupId);
            String result = ApproximateUtils.formatApproximateResult(count, ApproximateUtils.countError(samples, count), this.confidence, true);
            output.appendSlice(Slices.utf8Slice((String)result));
        }
    }
}

