/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.GroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.event.client.TypeParameterUtils;
import java.lang.reflect.Type;

public abstract class AbstractAggregationFunction<T extends AccumulatorState>
extends SimpleAggregationFunction {
    private final AccumulatorStateFactory<T> stateFactory;

    protected AbstractAggregationFunction(com.facebook.presto.spi.type.Type finalType, com.facebook.presto.spi.type.Type intermediateType, com.facebook.presto.spi.type.Type parameterType) {
        super(finalType, intermediateType, parameterType);
        Type[] types = TypeParameterUtils.getTypeParameters(AbstractAggregationFunction.class, this.getClass());
        Preconditions.checkState((types.length == 1 && types[0] instanceof Class ? 1 : 0) != 0);
        this.stateFactory = new StateCompiler().generateStateFactory((Class)types[0]);
    }

    protected abstract void processInput(T var1, BlockCursor var2);

    protected void evaluateIntermediate(T state, BlockBuilder out) {
        this.evaluateFinal(state, out);
    }

    protected void processIntermediate(T state, BlockCursor cursor) {
        this.processInput(state, cursor);
    }

    protected abstract void evaluateFinal(T var1, BlockBuilder var2);

    private T createSingleState() {
        return (T)((AccumulatorState)this.stateFactory.createSingleState());
    }

    private T createGroupedState() {
        return (T)((AccumulatorState)this.stateFactory.createGroupedState());
    }

    @Override
    protected final GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"Approximate queries not supported");
        Preconditions.checkArgument((!sampleWeightChannel.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
        return new GenericGroupedAccumulator(valueChannel, maskChannel);
    }

    @Override
    protected final Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"Approximate queries not supported");
        Preconditions.checkArgument((!sampleWeightChannel.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
        return new GenericAccumulator(valueChannel, maskChannel);
    }

    public final class GenericAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private final T state;

        public GenericAccumulator(int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, AbstractAggregationFunction.this.getFinalType(), AbstractAggregationFunction.this.getIntermediateType(), maskChannel, (Optional<Integer>)Optional.absent());
            this.state = AbstractAggregationFunction.this.createSingleState();
        }

        @Override
        protected void processInput(Block block, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            Preconditions.checkArgument((!sampleWeightBlock.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
            BlockCursor values = block.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (masks != null && !masks.getBoolean() || values.isNull()) continue;
                AbstractAggregationFunction.this.processInput(this.state, values);
            }
        }

        @Override
        public long getEstimatedSize() {
            return this.state.getEstimatedSize();
        }

        @Override
        protected void processIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                AbstractAggregationFunction.this.processIntermediate(this.state, intermediates);
            }
        }

        @Override
        protected void evaluateIntermediate(BlockBuilder out) {
            AbstractAggregationFunction.this.evaluateIntermediate(this.state, out);
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            AbstractAggregationFunction.this.evaluateFinal(this.state, out);
        }
    }

    public final class GenericGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final T state;
        private final GroupedAccumulatorState groupedState;

        public GenericGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, AbstractAggregationFunction.this.getFinalType(), AbstractAggregationFunction.this.getIntermediateType(), maskChannel, (Optional<Integer>)Optional.absent());
            this.state = AbstractAggregationFunction.this.createGroupedState();
            Preconditions.checkArgument((boolean)(this.state instanceof GroupedAccumulatorState), (Object)"state is not a GroupedAccumulatorState");
            this.groupedState = (GroupedAccumulatorState)this.state;
        }

        @Override
        public long getEstimatedSize() {
            return this.state.getEstimatedSize();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block valuesBlock, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            Preconditions.checkArgument((!sampleWeightBlock.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
            this.groupedState.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor values = valuesBlock.cursor();
            BlockCursor masks = null;
            if (maskBlock.isPresent()) {
                masks = ((Block)maskBlock.get()).cursor();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)values.advanceNextPosition());
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                if (masks != null && !masks.getBoolean() || values.isNull()) continue;
                this.groupedState.setGroupId(groupIdsBlock.getGroupId(position));
                AbstractAggregationFunction.this.processInput(this.state, values);
            }
            Preconditions.checkState((!values.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        protected void processIntermediate(GroupByIdBlock groupIdsBlock, Block intermediatesBlock) {
            this.groupedState.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = intermediatesBlock.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                if (intermediates.isNull()) continue;
                this.groupedState.setGroupId(groupIdsBlock.getGroupId(position));
                AbstractAggregationFunction.this.processIntermediate(this.state, intermediates);
            }
            Preconditions.checkState((!intermediates.advanceNextPosition() ? 1 : 0) != 0);
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.groupedState.setGroupId(groupId);
            AbstractAggregationFunction.this.evaluateIntermediate(this.state, output);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.groupedState.setGroupId(groupId);
            AbstractAggregationFunction.this.evaluateFinal(this.state, output);
        }
    }
}

