/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.sql.tree.Input;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class WindowFunctionDefinition {
    private final WindowFunctionSupplier functionSupplier;
    private final List<Integer> argumentChannels;

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, List<Input> inputs) {
        Preconditions.checkNotNull((Object)functionSupplier, (Object)"functionSupplier is null");
        Preconditions.checkNotNull(inputs, (Object)"inputs is null");
        return new WindowFunctionDefinition(functionSupplier, Lists.transform(inputs, (Function)Input.channelGetter()));
    }

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Input ... inputs) {
        Preconditions.checkNotNull((Object)functionSupplier, (Object)"functionSupplier is null");
        Preconditions.checkNotNull((Object)inputs, (Object)"inputs is null");
        return WindowFunctionDefinition.window(functionSupplier, Arrays.asList(inputs));
    }

    WindowFunctionDefinition(WindowFunctionSupplier functionSupplier, List<Integer> argumentChannels) {
        this.functionSupplier = functionSupplier;
        this.argumentChannels = argumentChannels;
    }

    public WindowFunction createWindowFunction() {
        return this.functionSupplier.createWindowFunction(this.argumentChannels);
    }
}

