/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SimplePagesHashStrategy
implements PagesHashStrategy {
    private final List<List<Block>> channels;
    private final List<List<Block>> hashChannels;

    public SimplePagesHashStrategy(List<List<Block>> channels, List<Integer> hashChannels) {
        this.channels = ImmutableList.copyOf(channels);
        ImmutableList.Builder hashChannelsBuilder = ImmutableList.builder();
        for (int hashChannel : hashChannels) {
            hashChannelsBuilder.add(channels.get(hashChannel));
        }
        this.hashChannels = hashChannelsBuilder.build();
    }

    @Override
    public int getChannelCount() {
        return this.channels.size();
    }

    @Override
    public void appendTo(int blockIndex, int blockPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        for (List<Block> channel : this.channels) {
            Block block = channel.get(blockIndex);
            block.appendTo(blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    @Override
    public int hashPosition(int blockIndex, int blockPosition) {
        int result = 0;
        for (List<Block> channel : this.hashChannels) {
            Block block = channel.get(blockIndex);
            result = result * 31 + block.hash(blockPosition);
        }
        return result;
    }

    @Override
    public boolean positionEqualsCursors(int blockIndex, int blockPosition, BlockCursor[] cursors) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            List<Block> channel = this.hashChannels.get(i);
            Block block = channel.get(blockIndex);
            if (block.equalTo(blockPosition, cursors[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsPosition(int leftBlockIndex, int leftBlockPosition, int rightBlockIndex, int rightBlockPosition) {
        for (List<Block> channel : this.hashChannels) {
            Block rightBlock;
            Block leftBlock = channel.get(leftBlockIndex);
            if (leftBlock.equalTo(leftBlockPosition, rightBlock = channel.get(rightBlockIndex), rightBlockPosition)) continue;
            return false;
        }
        return true;
    }
}

