/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.base.Preconditions;
import java.util.List;

public class SimpleJoinProbe
implements JoinProbe {
    private final LookupSource lookupSource;
    private final BlockCursor[] cursors;
    private final BlockCursor[] probeCursors;

    private SimpleJoinProbe(LookupSource lookupSource, Page page, List<Integer> probeJoinChannels) {
        int i;
        this.lookupSource = lookupSource;
        this.cursors = new BlockCursor[page.getChannelCount()];
        this.probeCursors = new BlockCursor[probeJoinChannels.size()];
        for (i = 0; i < page.getChannelCount(); ++i) {
            this.cursors[i] = page.getBlock(i).cursor();
        }
        for (i = 0; i < probeJoinChannels.size(); ++i) {
            this.probeCursors[i] = this.cursors[probeJoinChannels.get(i)];
        }
    }

    @Override
    public int getChannelCount() {
        return this.cursors.length;
    }

    @Override
    public boolean advanceNextPosition() {
        boolean advanced = this.cursors[0].advanceNextPosition();
        for (int i = 1; i < this.cursors.length; ++i) {
            Preconditions.checkState((advanced == this.cursors[i].advanceNextPosition() ? 1 : 0) != 0);
        }
        return advanced;
    }

    @Override
    public void appendTo(PageBuilder pageBuilder) {
        for (int outputIndex = 0; outputIndex < this.cursors.length; ++outputIndex) {
            BlockCursor cursor = this.cursors[outputIndex];
            cursor.appendTo(pageBuilder.getBlockBuilder(outputIndex));
        }
    }

    @Override
    public long getCurrentJoinPosition() {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        return this.lookupSource.getJoinPosition(this.probeCursors);
    }

    private boolean currentRowContainsNull() {
        for (BlockCursor probeCursor : this.probeCursors) {
            if (!probeCursor.isNull()) continue;
            return true;
        }
        return false;
    }

    public static class SimpleJoinProbeFactory
    implements JoinProbeFactory {
        private List<Integer> probeJoinChannels;

        public SimpleJoinProbeFactory(List<Integer> probeJoinChannels) {
            this.probeJoinChannels = probeJoinChannels;
        }

        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            return new SimpleJoinProbe(lookupSource, page, this.probeJoinChannels);
        }
    }
}

