/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.Page;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OperatorContext {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final int operatorId;
    private final String operatorType;
    private final DriverContext driverContext;
    private final Executor executor;
    private final AtomicLong intervalWallStart = new AtomicLong();
    private final AtomicLong intervalCpuStart = new AtomicLong();
    private final AtomicLong intervalUserStart = new AtomicLong();
    private final AtomicLong addInputCalls = new AtomicLong();
    private final AtomicLong addInputWallNanos = new AtomicLong();
    private final AtomicLong addInputCpuNanos = new AtomicLong();
    private final AtomicLong addInputUserNanos = new AtomicLong();
    private final CounterStat inputDataSize = new CounterStat();
    private final CounterStat inputPositions = new CounterStat();
    private final AtomicLong getOutputCalls = new AtomicLong();
    private final AtomicLong getOutputWallNanos = new AtomicLong();
    private final AtomicLong getOutputCpuNanos = new AtomicLong();
    private final AtomicLong getOutputUserNanos = new AtomicLong();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicLong finishCalls = new AtomicLong();
    private final AtomicLong finishWallNanos = new AtomicLong();
    private final AtomicLong finishCpuNanos = new AtomicLong();
    private final AtomicLong finishUserNanos = new AtomicLong();
    private final AtomicLong memoryReservation = new AtomicLong();
    private final AtomicReference<Supplier<Object>> infoSupplier = new AtomicReference();

    public OperatorContext(int operatorId, String operatorType, DriverContext driverContext, Executor executor) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.operatorType = (String)Preconditions.checkNotNull((Object)operatorType, (Object)"operatorType is null");
        this.driverContext = (DriverContext)Preconditions.checkNotNull((Object)driverContext, (Object)"driverContext is null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public ConnectorSession getSession() {
        return this.driverContext.getSession();
    }

    public boolean isDone() {
        return this.driverContext.isDone();
    }

    public void startIntervalTimer() {
        this.intervalWallStart.set(System.nanoTime());
        this.intervalCpuStart.set(this.currentThreadCpuTime());
        this.intervalUserStart.set(this.currentThreadUserTime());
    }

    public void recordAddInput(Page page) {
        this.addInputCalls.incrementAndGet();
        this.addInputWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.addInputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.addInputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.inputDataSize.update(page.getDataSize().toBytes());
            this.inputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedInput(DataSize dataSize, long positions, long readNanos) {
        this.inputDataSize.update(dataSize.toBytes());
        this.inputPositions.update(positions);
        this.addInputWallNanos.getAndAdd(readNanos);
    }

    public void recordGeneratedInput(DataSize dataSize, long positions) {
        this.recordGeneratedInput(dataSize, positions, 0L);
    }

    public void recordGetOutput(Page page) {
        this.getOutputCalls.incrementAndGet();
        this.getOutputWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.getOutputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.getOutputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.outputDataSize.update(page.getDataSize().toBytes());
            this.outputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedOutput(DataSize dataSize, long positions) {
        this.outputDataSize.update(dataSize.toBytes());
        this.outputPositions.update(positions);
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Preconditions.checkNotNull(blocked, (Object)"blocked is null");
        blocked.addListener(new Runnable(){
            private final long start = System.nanoTime();

            @Override
            public void run() {
                OperatorContext.this.blockedWallNanos.getAndAdd(OperatorContext.nanosBetween(this.start, System.nanoTime()));
            }
        }, this.executor);
    }

    public void recordFinish() {
        this.finishCalls.incrementAndGet();
        this.finishWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.finishCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.finishUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
    }

    public DataSize getMaxMemorySize() {
        return this.driverContext.getMaxMemorySize();
    }

    public DataSize getOperatorPreAllocatedMemory() {
        return this.driverContext.getOperatorPreAllocatedMemory();
    }

    public boolean reserveMemory(long bytes) {
        boolean result = this.driverContext.reserveMemory(bytes);
        if (result) {
            this.memoryReservation.getAndAdd(bytes);
        }
        return result;
    }

    public synchronized long setMemoryReservation(long newMemoryReservation) {
        Preconditions.checkArgument((newMemoryReservation >= 0L ? 1 : 0) != 0, (Object)"newMemoryReservation is negative");
        long delta = newMemoryReservation - this.memoryReservation.get();
        if (delta > 0L && !this.reserveMemory(delta)) {
            throw new ExceededMemoryLimitException(this.getMaxMemorySize());
        }
        return newMemoryReservation;
    }

    public void setInfoSupplier(Supplier<Object> infoSupplier) {
        Preconditions.checkNotNull(infoSupplier, (Object)"infoProvider is null");
        this.infoSupplier.set(infoSupplier);
    }

    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    public OperatorStats getOperatorStats() {
        Supplier<Object> infoSupplier = this.infoSupplier.get();
        Object info = null;
        if (infoSupplier != null) {
            info = infoSupplier.get();
        }
        return new OperatorStats(this.operatorId, this.operatorType, this.addInputCalls.get(), new Duration((double)this.addInputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)this.inputDataSize.getTotalCount(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), this.inputPositions.getTotalCount(), this.getOutputCalls.get(), new Duration((double)this.getOutputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)this.outputDataSize.getTotalCount(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), this.outputPositions.getTotalCount(), new Duration((double)this.blockedWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), this.finishCalls.get(), new Duration((double)this.finishWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)this.memoryReservation.get(), DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), info);
    }

    private long currentThreadUserTime() {
        if (!this.driverContext.isCpuTimerEnabled()) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadUserTime();
    }

    private long currentThreadCpuTime() {
        if (!this.driverContext.isCpuTimerEnabled()) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long nanosBetween(long start, long end) {
        return Math.abs(end - start);
    }

    public static Function<OperatorContext, OperatorStats> operatorStatsGetter() {
        return new Function<OperatorContext, OperatorStats>(){

            public OperatorStats apply(OperatorContext operatorContext) {
                return operatorContext.getOperatorStats();
            }
        };
    }
}

