/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Murmur3;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Arrays;

public final class InMemoryJoinHash
implements LookupSource {
    private final LongArrayList addresses;
    private final PagesHashStrategy pagesHashStrategy;
    private final int channelCount;
    private final int mask;
    private final int[] key;
    private final int[] positionLinks;

    public InMemoryJoinHash(LongArrayList addresses, PagesHashStrategy pagesHashStrategy, OperatorContext operatorContext) {
        this.addresses = (LongArrayList)Preconditions.checkNotNull((Object)addresses, (Object)"addresses is null");
        this.pagesHashStrategy = (PagesHashStrategy)Preconditions.checkNotNull((Object)pagesHashStrategy, (Object)"pagesHashStrategy is null");
        this.channelCount = pagesHashStrategy.getChannelCount();
        Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        int hashSize = HashCommon.arraySize((int)addresses.size(), (float)0.75f);
        operatorContext.reserveMemory(SizeOf.sizeOfIntArray((int)hashSize) + SizeOf.sizeOfIntArray((int)addresses.size()));
        this.mask = hashSize - 1;
        this.key = new int[hashSize];
        Arrays.fill(this.key, -1);
        this.positionLinks = new int[addresses.size()];
        Arrays.fill(this.positionLinks, -1);
        int position = 0;
        while (position < addresses.size()) {
            int pos = (int)Murmur3.hash64((long)this.hashPosition(position)) & this.mask;
            while (this.key[pos] != -1) {
                int currentKey = this.key[pos];
                if (this.positionEqualsPosition(currentKey, position)) {
                    this.positionLinks[position] = currentKey;
                    break;
                }
                pos = pos + 1 & this.mask;
            }
            this.key[pos] = position++;
        }
    }

    @Override
    public final int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public final long getJoinPosition(BlockCursor ... cursors) {
        int pos = (int)Murmur3.hash64((long)this.hashCursor(cursors)) & this.mask;
        while (this.key[pos] != -1) {
            if (this.positionEqualsCurrentRow(this.key[pos], cursors)) {
                return this.key[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return -1L;
    }

    @Override
    public final long getNextJoinPosition(long currentPosition) {
        return this.positionLinks[Ints.checkedCast((long)currentPosition)];
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        long pageAddress = this.addresses.getLong(Ints.checkedCast((long)position));
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        this.pagesHashStrategy.appendTo(blockIndex, blockPosition, pageBuilder, outputChannelOffset);
    }

    private int hashCursor(BlockCursor ... cursors) {
        int result = 0;
        for (BlockCursor cursor : cursors) {
            result = result * 31 + cursor.hash();
        }
        return result;
    }

    private int hashPosition(int position) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.hashPosition(blockIndex, blockPosition);
    }

    private boolean positionEqualsCurrentRow(int position, BlockCursor ... cursors) {
        long pageAddress = this.addresses.getLong(position);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.pagesHashStrategy.positionEqualsCursors(blockIndex, blockPosition, cursors);
    }

    private boolean positionEqualsPosition(int leftPosition, int rightPosition) {
        long leftPageAddress = this.addresses.getLong(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = this.addresses.getLong(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        return this.pagesHashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
    }
}

