/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class InMemoryExchangeSinkOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final InMemoryExchange inMemoryExchange;
    private boolean finished;

    InMemoryExchangeSinkOperator(OperatorContext operatorContext, InMemoryExchange inMemoryExchange) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.inMemoryExchange = (InMemoryExchange)Preconditions.checkNotNull((Object)inMemoryExchange, (Object)"inMemoryExchange is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.inMemoryExchange.getTypes();
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.finished = true;
            this.inMemoryExchange.sinkFinished();
        }
    }

    @Override
    public boolean isFinished() {
        if (!this.finished) {
            this.finished = this.inMemoryExchange.isFinishing();
        }
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.inMemoryExchange.waitForWriting();
        if (blocked.isDone()) {
            return NOT_BLOCKED;
        }
        return blocked;
    }

    @Override
    public boolean needsInput() {
        return !this.isFinished() && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Already finished");
        this.inMemoryExchange.addPage(page);
        this.operatorContext.recordGeneratedOutput(page.getDataSize(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }
}

