/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class GroupByIdBlock
implements Block {
    private final long groupCount;
    private final Block block;

    public GroupByIdBlock(long groupCount, Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkArgument((boolean)block.getType().equals(BigintType.BIGINT));
        this.groupCount = groupCount;
        this.block = block;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public long getGroupId(int position) {
        return this.block.getLong(position);
    }

    public Block getRegion(int positionOffset, int length) {
        return this.block.getRegion(positionOffset, length);
    }

    public boolean getBoolean(int position) {
        throw new UnsupportedOperationException();
    }

    public long getLong(int position) {
        return this.block.getLong(position);
    }

    public double getDouble(int position) {
        throw new UnsupportedOperationException();
    }

    public Object getObjectValue(ConnectorSession session, int position) {
        return this.block.getObjectValue(session, position);
    }

    public Slice getSlice(int position) {
        throw new UnsupportedOperationException();
    }

    public Block getSingleValueBlock(int position) {
        return this.block.getSingleValueBlock(position);
    }

    public boolean isNull(int position) {
        return this.block.isNull(position);
    }

    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        return this.block.equalTo(position, otherBlock, otherPosition);
    }

    public boolean equalTo(int position, BlockCursor cursor) {
        return this.block.equalTo(position, cursor);
    }

    public boolean equalTo(int position, Slice otherSlice, int otherOffset) {
        return this.block.equalTo(position, otherSlice, otherOffset);
    }

    public int hash(int position) {
        return this.block.hash(position);
    }

    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        return this.block.compareTo(sortOrder, position, otherBlock, otherPosition);
    }

    public int compareTo(SortOrder sortOrder, int position, BlockCursor cursor) {
        return this.block.compareTo(sortOrder, position, cursor);
    }

    public int compareTo(int position, Slice otherSlice, int otherOffset) {
        return this.block.compareTo(position, otherSlice, otherOffset);
    }

    public void appendTo(int position, BlockBuilder blockBuilder) {
        this.block.appendTo(position, blockBuilder);
    }

    public Type getType() {
        return this.block.getType();
    }

    public int getPositionCount() {
        return this.block.getPositionCount();
    }

    public int getSizeInBytes() {
        return this.block.getSizeInBytes();
    }

    public BlockCursor cursor() {
        return this.block.cursor();
    }

    public BlockEncoding getEncoding() {
        return this.block.getEncoding();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("groupCount", this.groupCount).add("positionCount", this.getPositionCount()).toString();
    }
}

