/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Murmur3;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;

public class GroupByHash {
    private static final float FILL_RATIO = 0.75f;
    private final List<Type> types;
    private final int[] channels;
    private final ObjectArrayList<PageBuilder> pages;
    private long completedPagesMemorySize;
    private int maxFill;
    private int mask;
    private long[] key;
    private int[] value;
    private final LongBigArray groupAddress;
    private int nextGroupId;

    public GroupByHash(List<Type> types, int[] channels, int expectedSize) {
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        this.channels = (int[])((int[])Preconditions.checkNotNull((Object)channels, (Object)"channels is null")).clone();
        Preconditions.checkArgument((types.size() == channels.length ? 1 : 0) != 0, (Object)"types and channels have different sizes");
        this.pages = ObjectArrayList.wrap((Object[])new PageBuilder[1024], (int)0);
        this.pages.add((Object)new PageBuilder(types));
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = HashCommon.maxFill((int)hashSize, (float)0.75f);
        this.mask = hashSize - 1;
        this.key = new long[hashSize];
        Arrays.fill(this.key, -1L);
        this.value = new int[hashSize];
        this.groupAddress = new LongBigArray();
        this.groupAddress.ensureCapacity(this.maxFill);
    }

    public long getEstimatedSize() {
        return SizeOf.sizeOf((Object[])this.pages.elements()) + this.completedPagesMemorySize + ((PageBuilder)this.pages.get(this.pages.size() - 1)).getMemorySize() + SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value) + this.groupAddress.sizeOf();
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getGroupCount() {
        return this.nextGroupId;
    }

    public void appendValuesTo(int groupId, BlockBuilder[] builders) {
        long address = this.groupAddress.get(groupId);
        PageBuilder page = (PageBuilder)this.pages.get(SyntheticAddress.decodeSliceIndex(address));
        page.appendValuesTo(SyntheticAddress.decodePosition(address), builders);
    }

    public GroupByIdBlock getGroupIds(Page page) {
        int positionCount = page.getPositionCount();
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        BlockCursor[] currentRow = new BlockCursor[this.channels.length];
        for (int i = 0; i < this.channels.length; ++i) {
            currentRow[i] = page.getBlock(this.channels[i]).cursor();
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            for (BlockCursor cursor : currentRow) {
                Preconditions.checkState((boolean)cursor.advanceNextPosition());
            }
            int groupId = this.putIfAbsent(currentRow);
            blockBuilder.appendLong((long)groupId);
        }
        Block block = blockBuilder.build();
        return new GroupByIdBlock(this.nextGroupId, block);
    }

    public int putIfAbsent(BlockCursor[] cursors) {
        int hashPosition = (int)Murmur3.hash64((long)GroupByHash.hashCursor(cursors)) & this.mask;
        int groupId = -1;
        while (this.key[hashPosition] != -1L) {
            long address = this.key[hashPosition];
            if (this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(address), SyntheticAddress.decodePosition(address), cursors)) {
                groupId = this.value[hashPosition];
                break;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        if (groupId < 0) {
            groupId = this.addNewGroup(hashPosition, cursors);
        }
        return groupId;
    }

    private int addNewGroup(int hashPosition, BlockCursor[] cursors) {
        long address;
        int pageIndex = this.pages.size() - 1;
        PageBuilder pageBuilder = (PageBuilder)this.pages.get(pageIndex);
        pageBuilder.append(cursors);
        int groupId = this.nextGroupId++;
        this.key[hashPosition] = address = SyntheticAddress.encodeSyntheticAddress(pageIndex, pageBuilder.getPositionCount() - 1);
        this.value[hashPosition] = groupId;
        this.groupAddress.set(groupId, address);
        if (pageBuilder.isFull()) {
            this.completedPagesMemorySize += pageBuilder.getMemorySize();
            pageBuilder = new PageBuilder(this.types);
            this.pages.add((Object)pageBuilder);
        }
        if (this.nextGroupId >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return groupId;
    }

    private void rehash(int size) {
        int newSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        int newMask = newSize - 1;
        long[] newKey = new long[newSize];
        Arrays.fill(newKey, -1L);
        int[] newValue = new int[newSize];
        int oldIndex = 0;
        for (int groupId = 0; groupId < this.nextGroupId; ++groupId) {
            while (this.key[oldIndex] == -1L) {
                ++oldIndex;
            }
            long address = this.key[oldIndex];
            int pos = (int)Murmur3.hash64((long)this.hashPosition(address)) & newMask;
            while (newKey[pos] != -1L) {
                pos = pos + 1 & newMask;
            }
            newKey[pos] = address;
            newValue[pos] = this.value[oldIndex];
            ++oldIndex;
        }
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill((int)newSize, (float)0.75f);
        this.key = newKey;
        this.value = newValue;
        this.groupAddress.ensureCapacity(this.maxFill);
    }

    private static int hashCursor(BlockCursor ... cursors) {
        int result = 0;
        for (BlockCursor cursor : cursors) {
            result = result * 31 + cursor.hash();
        }
        return result;
    }

    private int hashPosition(long sliceAddress) {
        int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
        int position = SyntheticAddress.decodePosition(sliceAddress);
        return ((PageBuilder)this.pages.get(sliceIndex)).hashCode(position);
    }

    private boolean positionEqualsCurrentRow(int sliceIndex, int position, BlockCursor ... currentRow) {
        return ((PageBuilder)this.pages.get(sliceIndex)).equals(position, currentRow);
    }

    private static class PageBuilder {
        private final List<BlockBuilder> channels;
        private int positionCount;
        private boolean full;

        public PageBuilder(List<Type> types) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Type type : types) {
                builder.add((Object)type.createBlockBuilder(new BlockBuilderStatus()));
            }
            this.channels = builder.build();
        }

        public int getPositionCount() {
            return this.positionCount;
        }

        public long getMemorySize() {
            long memorySize = 0L;
            for (BlockBuilder channel : this.channels) {
                memorySize += (long)channel.getSizeInBytes();
            }
            return memorySize;
        }

        private void append(BlockCursor ... row) {
            for (int channel = 0; channel < row.length; ++channel) {
                row[channel].appendTo(this.channels.get(channel));
                this.full = this.full || this.channels.get(channel).isFull();
            }
            ++this.positionCount;
        }

        public void appendValuesTo(int position, BlockBuilder ... builders) {
            for (int i = 0; i < this.channels.size(); ++i) {
                BlockBuilder channel = this.channels.get(i);
                channel.appendTo(position, builders[i]);
            }
        }

        public int hashCode(int position) {
            int result = 0;
            for (BlockBuilder channel : this.channels) {
                result = 31 * result + channel.hash(position);
            }
            return result;
        }

        public boolean equals(int thisPosition, PageBuilder that, int thatPosition) {
            for (int i = 0; i < this.channels.size(); ++i) {
                BlockBuilder thatBlock;
                BlockBuilder thisBlock = this.channels.get(i);
                if (thisBlock.equalTo(thisPosition, (Block)(thatBlock = that.channels.get(i)), thatPosition)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(int position, BlockCursor ... row) {
            for (int i = 0; i < this.channels.size(); ++i) {
                BlockBuilder thisBlock = this.channels.get(i);
                if (thisBlock.equalTo(position, row[i])) continue;
                return false;
            }
            return true;
        }

        public boolean isFull() {
            return this.full;
        }
    }
}

