/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DistinctLimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final BlockCursor[] cursors;
    private final PageBuilder pageBuilder;
    private Page outputPage;
    private long remainingLimit;
    private boolean finishing;
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public DistinctLimitOperator(OperatorContext operatorContext, List<Type> types, long limit) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        ImmutableList.Builder distinctChannels = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            distinctTypes.add((Object)types.get(i));
            distinctChannels.add((Object)i);
        }
        this.groupByHash = new GroupByHash((List<Type>)distinctTypes.build(), Ints.toArray((Collection)distinctChannels.build()), Math.min((int)limit, 10000));
        this.cursors = new BlockCursor[types.size()];
        this.pageBuilder = new PageBuilder(this.getTypes());
        this.remainingLimit = limit;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
        Arrays.fill(this.cursors, null);
        this.pageBuilder.reset();
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null || this.remainingLimit == 0L && this.outputPage == null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        this.operatorContext.setMemoryReservation(this.groupByHash.getEstimatedSize());
        return !this.finishing && this.remainingLimit > 0L && this.outputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        this.operatorContext.setMemoryReservation(this.groupByHash.getEstimatedSize());
        for (int i = 0; i < page.getChannelCount(); ++i) {
            this.cursors[i] = page.getBlock(i).cursor();
        }
        this.pageBuilder.reset();
        GroupByIdBlock ids = this.groupByHash.getGroupIds(page);
        for (int i = 0; i < ids.getPositionCount(); ++i) {
            Preconditions.checkState((boolean)this.advanceNextCursorPosition());
            if (ids.getGroupId(i) != this.nextDistinctId) continue;
            for (int j = 0; j < this.cursors.length; ++j) {
                this.cursors[j].appendTo(this.pageBuilder.getBlockBuilder(j));
            }
            --this.remainingLimit;
            ++this.nextDistinctId;
            if (this.remainingLimit == 0L) break;
        }
        if (!this.pageBuilder.isEmpty()) {
            this.outputPage = this.pageBuilder.build();
        }
    }

    private boolean advanceNextCursorPosition() {
        boolean advanced = this.cursors[0].advanceNextPosition();
        for (int i = 1; i < this.cursors.length; ++i) {
            Preconditions.checkState((advanced == this.cursors[i].advanceNextPosition() ? 1 : 0) != 0);
        }
        if (!advanced) {
            Arrays.fill(this.cursors, null);
        }
        return advanced;
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class DistinctLimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> types;
        private final long limit;
        private boolean closed;

        public DistinctLimitOperatorFactory(int operatorId, List<? extends Type> types, long limit) {
            this.operatorId = operatorId;
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
            this.limit = limit;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, DistinctLimitOperator.class.getSimpleName());
            return new DistinctLimitOperator(operatorContext, this.types, this.limit);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

