/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.MemoryManager;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.Input;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class AggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final List<Aggregator> aggregates;
    private State state = State.NEEDS_INPUT;

    public AggregationOperator(OperatorContext operatorContext, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)((Object)step), (Object)"step is null");
        Preconditions.checkNotNull(functionDefinitions, (Object)"functionDefinitions is null");
        this.types = AggregationOperator.toTypes(step, functionDefinitions);
        MemoryManager memoryManager = new MemoryManager(operatorContext);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AggregationFunctionDefinition functionDefinition : functionDefinitions) {
            builder.add((Object)new Aggregator(functionDefinition, step, memoryManager));
        }
        this.aggregates = builder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        for (Aggregator aggregate : this.aggregates) {
            aggregate.processPage(page);
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        Block[] blocks = new Block[this.aggregates.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.aggregates.get(i).evaluate();
        }
        this.state = State.FINISHED;
        return new Page(blocks);
    }

    private static List<Type> toTypes(AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (AggregationFunctionDefinition functionDefinition : functionDefinitions) {
            if (step != AggregationNode.Step.PARTIAL) {
                types.add((Object)functionDefinition.getFunction().getFinalType());
                continue;
            }
            types.add((Object)functionDefinition.getFunction().getIntermediateType());
        }
        return types.build();
    }

    private static class Aggregator {
        private final Accumulator aggregation;
        private final AggregationNode.Step step;
        private final MemoryManager memoryManager;
        private final int intermediateChannel;

        private Aggregator(AggregationFunctionDefinition functionDefinition, AggregationNode.Step step, MemoryManager memoryManager) {
            AggregationFunction function = functionDefinition.getFunction();
            if (step != AggregationNode.Step.FINAL) {
                int[] argumentChannels = new int[functionDefinition.getInputs().size()];
                for (int i = 0; i < argumentChannels.length; ++i) {
                    argumentChannels[i] = functionDefinition.getInputs().get(i).getChannel();
                }
                this.intermediateChannel = -1;
                this.aggregation = function.createAggregation((Optional<Integer>)functionDefinition.getMask().transform(Input.channelGetter()), (Optional<Integer>)functionDefinition.getSampleWeight().transform(Input.channelGetter()), functionDefinition.getConfidence(), argumentChannels);
            } else {
                Preconditions.checkArgument((functionDefinition.getInputs().size() == 1 ? 1 : 0) != 0, (Object)"Expected a single input for an intermediate aggregation");
                this.intermediateChannel = functionDefinition.getInputs().get(0).getChannel();
                this.aggregation = function.createIntermediateAggregation(functionDefinition.getConfidence());
            }
            this.step = step;
            this.memoryManager = memoryManager;
        }

        public Type getType() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                return this.aggregation.getIntermediateType();
            }
            return this.aggregation.getFinalType();
        }

        public void processPage(Page page) {
            if (this.step == AggregationNode.Step.FINAL) {
                this.aggregation.addIntermediate(page.getBlock(this.intermediateChannel));
            } else {
                this.aggregation.addInput(page);
            }
            if (!this.memoryManager.canUse(this.aggregation.getEstimatedSize())) {
                throw new ExceededMemoryLimitException(this.memoryManager.getMaxMemorySize());
            }
        }

        public Block evaluate() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                return this.aggregation.evaluateIntermediate();
            }
            return this.aggregation.evaluateFinal();
        }
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class AggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final AggregationNode.Step step;
        private final List<AggregationFunctionDefinition> functionDefinitions;
        private final List<Type> types;
        private boolean closed;

        public AggregationOperatorFactory(int operatorId, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
            this.operatorId = operatorId;
            this.step = step;
            this.functionDefinitions = functionDefinitions;
            this.types = AggregationOperator.toTypes(step, functionDefinitions);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, AggregationOperator.class.getSimpleName());
            return new AggregationOperator(operatorContext, this.step, this.functionDefinitions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

