/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;

public enum OperatorType {
    ADD("+"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    SUBTRACT("-"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    MULTIPLY("*"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    DIVIDE("/"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    MODULUS("%"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    NEGATION("-"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 1);
        }
    }
    ,
    EQUAL("="){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    NOT_EQUAL("<>"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    LESS_THAN("<"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    LESS_THAN_OR_EQUAL("<="){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    GREATER_THAN_OR_EQUAL(">="){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    BETWEEN("BETWEEN"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 3);
        }
    }
    ,
    CAST("CAST"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 1);
        }
    }
    ,
    HASH_CODE("HASH CODE"){

        @Override
        void validateSignature(Type returnType, List<Type> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 1);
            Preconditions.checkArgument((boolean)returnType.equals(BigintType.BIGINT), (String)"%s operator must return a BIGINT: %s", (Object[])new Object[]{this, OperatorType.formatSignature((OperatorType)this, returnType, argumentTypes)});
        }
    };

    private final String operator;

    private OperatorType(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    abstract void validateSignature(Type var1, List<Type> var2);

    private static void validateOperatorSignature(OperatorType operatorType, Type returnType, List<Type> argumentTypes, int expectedArgumentCount) {
        String signature = OperatorType.formatSignature(operatorType, returnType, argumentTypes);
        Preconditions.checkArgument((!returnType.equals(UnknownType.UNKNOWN) ? 1 : 0) != 0, (String)"%s operator return type can not be NULL: %s", (Object[])new Object[]{operatorType, signature});
        Preconditions.checkArgument((argumentTypes.size() == expectedArgumentCount ? 1 : 0) != 0, (String)"%s operator must have exactly %s argument: %s", (Object[])new Object[]{operatorType, expectedArgumentCount, signature});
    }

    private static void validateComparisonOperatorSignature(OperatorType operatorType, Type returnType, List<Type> argumentTypes, int expectedArgumentCount) {
        OperatorType.validateOperatorSignature(operatorType, returnType, argumentTypes, expectedArgumentCount);
        Preconditions.checkArgument((boolean)returnType.equals(BooleanType.BOOLEAN), (String)"%s operator must return a BOOLEAN: %s", (Object[])new Object[]{operatorType, OperatorType.formatSignature(operatorType, returnType, argumentTypes)});
    }

    private static String formatSignature(OperatorType operatorType, Type returnType, List<Type> argumentTypes) {
        return (Object)((Object)operatorType) + "(" + Joiner.on((String)", ").join(argumentTypes) + ")::" + returnType;
    }
}

